import urllib
import urllib2
from lxml import etree

CONSUMER_KEY = 'HAx8kcrVi8z6jsPxPSMrWA'
USER_AGENT = 'Firefox/3.5 Maemo Browser 1.5.6 RX-51 N900'
QYPE_URL = 'http://api.qype.com/v1/'



class place_result:
    def __init__(self):
        self.first_page = None
        self.last_page = None
        self.previous_page = None
        self.next_page = None
        self.places = []
        

def get_categories(category_link=None, lang='en_GB'):
    """Return subcategories in the specified category
    category_link : link of the category 
    lang : language content result"""
      
    xml_data = get_data(category_link , lang)
    
    categories = []
    root = etree.XML(xml_data)
    for category in root.iter('category'):
        id = category.find('id').text.split('/')[-1]
        children_link = None
        for link in category.findall('link'):
            if link.get("rel") == 'http://schemas.qype.com/place_categories.children':
                children_link = link.get('href')
        if children_link:
            categories.append({'title' : category.find('title').text, 
                                      'category_link' : children_link})
        else:
            categories.append({'title' : category.find('title').text, 
                                      'category_link' : id})

    return categories
    
    
def get_places_from_coord(latitude,  longitude,  category,  lang='en_GB'):
    """Get places in the specified category by position
    latitude : latitude
    longitude : longitude
    category : category id
    lang : language content"""
    url = "%spositions/%s,%s/places" % (QYPE_URL, latitude, longitude)
    xml_data = get_data(url,  lang,  {'in_category' : category})
        
    return process_places_result(xml_data)
    
    
def get_places_from_url(url,  lang='en_GB'):
    """Get places in the specified url
    lurl : url to retrieve
    lang : language content"""
    xml_data = get_data(url,  lang)
        
    return process_places_result(xml_data)
    
    
def process_places_result(xml_data):
    root = etree.XML(xml_data)
    
    #Parse navigation links
    result = place_result()
    for nav_link in root.iter('link'):
        if nav_link.get("rel") == 'first':
            result.first_page = nav_link.get('href')
        if nav_link.get("rel") == 'previous':
            result.previous_page = nav_link.get('href')
        if nav_link.get("rel") == 'next':
            result.next_page = nav_link.get('href')
        if nav_link.get("rel") == 'last':
            result.last_page = nav_link.get('href')
    
    #Parse places
    for place in root.iter('place'):
        result.places.append({'title' : place.find('title').text, 
                                'url' : place.findtext('url'), 
                                'id' : place.find('id').text, 
                                'hours' : place.findtext('opening_hours'), 
                                'phone' : place.findtext('phone'), 
                                'rating' : place.findtext('average_rating'), 
                                'distance' : place.findtext('distance'), 
                                'postcode' : place.find('address').findtext('postcode'), 
                                'city' : place.find('address').findtext('city'), 
                                'housenumber' : place.find('address').findtext('housenumber'), 
                                'street' : place.find('address').findtext('street'), 
                                'latitude' : place.findtext('point').split(',')[0],
                                'longitude' : place.findtext('point').split(',')[1]})
    return result
    

def get_data(url,  lang='en_GB',  data=None):
    """Retrieve the specified url
    url : url to retrieve
    lang : language content result
    data : query parameters"""
    
    headers = {'User-Agent' : USER_AGENT}
    values = {'consumer_key' : CONSUMER_KEY, 
                   'lang' : lang}
    if data:
        values.update(data)
    url = url + '?' + urllib.urlencode(values)
    print url
    req = urllib2.Request(url,  None,  headers)
    xml_data = urllib2.urlopen(req).read()
    return xml_data[xml_data.find('<?xml version='):]
    
    
if __name__ == "__main__":
    print get_categories(lang='fr_FR')
