import hildon
import gtk

import config

ABOUT_MESSAGE = """Qypy is an unofficial application using Qype service

<b>Developper : </b>David Hautbois
<b>Email :</b> david.hautbois@free.fr
<b>Data source :</b> http://www.qype.co.uk"""

def create_menu(window,  label):
    """Build the menu"""
    
    menu = hildon.AppMenu()
    button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    button.set_label("Language...")
    button.connect("clicked", display_language_dialog,  window)
    menu.append(button)
    button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
    button.set_label("About...")
    button.connect("clicked", display_about_dialog,  window)
    menu.append(button)
    menu.show_all()
    return menu
    
    
def create_language_selector():
    current_config = config.config()
    languages = ('English',  'Francais',  'Deutsch')
    selector = hildon.TouchSelector(text = True)

    current_language = current_config.language

    i = 0
    for language in languages:
        selector.append_text(language)
        if language==current_language: selector.set_active(0, i)
        i +=1      
    
    selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)

    return selector
    

def language_selector_changed(selector, window):
    current_config = config.config()
    current_selection = selector.get_current_text()
    print "Current selection : %s" % (current_selection)
    current_config.set_language(current_selection)


def display_language_dialog(widget,  window):
    language_window = hildon.StackableWindow()

    selector = create_language_selector()
    selector.connect("changed", language_selector_changed)
    language_window.add(selector)

    language_window.set_title("Select language")

    language_window.show_all()
    
    
def display_about_dialog(widget,  window):
    about_window = hildon.StackableWindow()    
    vbox = gtk.VBox(False, 0)
    label = gtk.Label()
    label.set_markup(ABOUT_MESSAGE)
    vbox.pack_start(label, True, True, 0)
    i = gtk.Image()
    i.set_from_file("/usr/share/qypy/qype_icon.png")
    vbox.pack_start(i);
    about_window.add(vbox)  
    about_window.set_title("About Qypy")
    about_window.show_all()
