"""The main class for the application"""
import gtk
import hildon
import os.path
import gobject          
import osso
import sys
import dbus
import location
import time

import utils
import menu
import config

APPNAME = 'qypy'
APPVERSION = '0.0.1'
MAP_URL = """http://david.hautbois.free.fr/maps/qypy.php?\
source_lat=%s&source_long=%s&dest_lat=%s&dest_long=%s"""
MEDIA_PATH = "/usr/share/qypy/"
STARS = {'0': gtk.gdk.pixbuf_new_from_file(MEDIA_PATH + 'star_0.png'),
               '1': gtk.gdk.pixbuf_new_from_file(MEDIA_PATH + 'star_1.png'),
               '2': gtk.gdk.pixbuf_new_from_file(MEDIA_PATH + 'star_2.png'),
               '3': gtk.gdk.pixbuf_new_from_file(MEDIA_PATH + 'star_3.png'),
               '4': gtk.gdk.pixbuf_new_from_file(MEDIA_PATH + 'star_4.png'),
                '5': gtk.gdk.pixbuf_new_from_file(MEDIA_PATH + 'star_5.png')}
MAP_ICON = '/usr/share/icons/hicolor/64x64/hildon/general_web.png'
CALL_ICON = '/usr/share/icons/hicolor/64x64/hildon/general_call.png'
FIRSTPAGE_ICON ='/usr/share/icons/hicolor/48x48/hildon/pdf_viewer_first_page.png'
LASTPAGE_ICON ='/usr/share/icons/hicolor/48x48/hildon/pdf_viewer_last_page.png'
PREVIOUSPAGE_ICON ='/usr/share/icons/hicolor/48x48/hildon/general_back.png'
NEXTPAGE_ICON ='/usr/share/icons/hicolor/48x48/hildon/general_forward.png'
   

class  qypyApp(hildon.Program):

    def __init__(self):
        """Contains main methods for the app class"""
        
        #Initializing GPS
        self.previousfixtime = float("nan")
        if not os.path.isfile('scratchbox'):
            self.latitude = None
            self.longitude = None
            self.control = location.GPSDControl.get_default()
            self.device = location.GPSDevice()
            self.device.reset_last_known()
            self.control.set_properties(
                                    preferred_method=location.METHOD_USER_SELECTED,
                                    preferred_interval=location.INTERVAL_DEFAULT)
            self.device.connect("changed", self.gps_on_changed, self.control)
            self.control.start()
        else:
            self.latitude = 48.769065
            self.longitude = 2.027348
        

        hildon.Program.__init__(self)
        self.window = hildon.StackableWindow()
        self.add_window(self.window)        
        self.window.set_title("Qypy")
        
        self.osso_c = osso.Context("qypy", "0.0.1", False)
        self.osso_r = osso.Rpc(self.osso_c)

        menu_label = gtk.Label("Parameters")
        self.menu = menu.create_menu(self.window,  menu_label)
        self.window.set_app_menu(self.menu)
        
        self.build_main_interface()

        self.window.show_all()
        self.window.connect("delete_event", self.quit, None)
        
        self.config = config.config()
        
        self.language = self.config.language_code()
        print self.language
        
        #self.nearbyme_places_window(None,  883)
        
        gtk.main()
        
        
    def build_main_interface(self):
        vbox = gtk.VBox(False, 0)
        i = gtk.Image()
        i.set_from_file("/usr/share/qypy/qype.jpg")
        vbox.pack_start(i);
        self.near_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        self.near_button.set_label("Near by me...")
        if not os.path.isfile('scratchbox'):
            self.near_button.set_sensitive(False)
        self.near_button.connect("clicked", self.nearbyme_categories_window, 'http://api.qype.com/v1/place_categories')
        vbox.pack_start(self.near_button)
        button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)        
        button.set_label("Search...")
        button.set_sensitive(False)
        vbox.pack_start(button)
        
        self.window.add(vbox)
        
        
    def nearbyme_categories_window(self,  widget,  url):
        try:
            categories = utils.get_categories(category_link=url,  lang=self.language)
        except Exception, err:
            self.warning_message(sys.exc_info()[0].__name__,  err)
            return
        
        #Check if there are subcategories
        if len(categories)==0:
            print "No subcategories in %s, go to places" % url[40:-9]
            self.nearbyme_places_window(None,  url[40:-9])
            return
      
        #Add link to category places, except if top
        if url != 'http://api.qype.com/v1/place_categories':
            categories.insert(0,  {'title' : "Places", 
                                        'category_link' : url[40:-9]})
      
        window = hildon.StackableWindow()       
        window.set_title("Qypy")
        selector = hildon.TouchSelector(text=True)
        selector.set_column_selection_mode(hildon.TOUCH_SELECTOR_SELECTION_MODE_SINGLE)
        selector.connect("changed", self.category_selector_changed,  categories)

        for category in categories:
            print category['title']
            selector.append_text(category['title'])


        window.add(selector)
        window.show_all()
        selector.set_active(0, -1)
        

    def nearbyme_places_window(self,  widget,  category_id):       
        
        try:
            places_result = utils.get_places_from_coord(self.latitude,  self.longitude,  category_id,  lang=self.language)
        except Exception, err:
            self.warning_message(sys.exc_info()[0].__name__,  err)
            return
            
        if len(places_result.places) == 0:
            hildon.hildon_banner_show_information(self.window, '', "No result")
            return
        window = self.build_places_window()        
        self.alter_places_window(None,  window,  places_result)
        window.set_title("Qypy")
        window.show_all()
        
        
    def build_places_window(self):
        places_window = hildon.StackableWindow()
        places_window.set_title("Qypy")
        
        parea = hildon.PannableArea()

        places_window.treeview = hildon.GtkTreeView(gtk.HILDON_UI_MODE_NORMAL)
        places_window.treeview.eventid = None
        parea.add(places_window.treeview)

        places_window.store = gtk.ListStore(str,  gtk.gdk.Pixbuf)
        
        #Column 0 for the treeview
        renderer = gtk.CellRendererText()
        column = gtk.TreeViewColumn("title", renderer, markup=0)
        column.set_property("expand", True)
        places_window.treeview.append_column(column)
        places_window.treeview.set_model(places_window.store)
        #Column 1 for the treeview
        renderer = gtk.CellRendererPixbuf()
        column = gtk.TreeViewColumn()
        column.pack_start(renderer, False)
        column.add_attribute(renderer, "pixbuf", 1)
        column.set_min_width(40)
        places_window.treeview.append_column(column)

                

        hbox = gtk.HBox(True, 0)
        places_window.first_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        places_window.first_button.set_image(gtk.image_new_from_file(FIRSTPAGE_ICON))
        places_window.first_button.eventid = None
        hbox.pack_start(places_window.first_button);
        places_window.previous_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        places_window.previous_button.set_image(gtk.image_new_from_file(PREVIOUSPAGE_ICON))
        places_window.previous_button.eventid = None
        hbox.pack_start(places_window.previous_button);
        places_window.next_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        places_window.next_button.set_image(gtk.image_new_from_file(NEXTPAGE_ICON))
        places_window.next_button.eventid = None
        hbox.pack_start(places_window.next_button);
        places_window.last_button = hildon.GtkButton(gtk.HILDON_SIZE_AUTO)
        places_window.last_button.set_image(gtk.image_new_from_file(LASTPAGE_ICON))
        places_window.last_button.eventid = None
        hbox.pack_start(places_window.last_button);
        
        places_window.vbox = gtk.VBox(False, 0)
        places_window.vbox.pack_start(hbox,  expand=False);
        places_window.vbox.pack_start(parea,  expand=True);
        
        places_window.add(places_window.vbox)        
        
        places_window.show_all()
        return places_window
        
        
    def button_clicked(self, widget, window, link):
        try:
            places_result = utils.get_places_from_url(link,  self.language)        
        except Exception, err:
            self.warning_message(sys.exc_info()[0].__name__,  err)
            return
        self.alter_places_window(None,  window, places_result)
        
        
    def alter_places_window(self,  widget,  window, places_result):
        
        print "Enter alter_places_window"
        if window.first_button.eventid:
            window.first_button.disconnect(window.first_button.eventid)
        if window.last_button.eventid:
            window.last_button.disconnect(window.last_button.eventid)
        if window.previous_button.eventid:
            window.previous_button.disconnect(window.previous_button.eventid)
        if window.next_button.eventid:
            window.next_button.disconnect(window.next_button.eventid)
        
        window.first_button.eventid = window.first_button.connect(
          "clicked", self.button_clicked, window,  places_result.first_page)
        window.last_button.eventid = window.last_button.connect(
          "clicked", self.button_clicked, window,  places_result.last_page)
        window.previous_button.eventid = window.previous_button.connect(
          "clicked", self.button_clicked, window,  places_result.previous_page)
        window.next_button.eventid = window.next_button.connect(
          "clicked", self.button_clicked, window,  places_result.next_page)
          
        if window.treeview.eventid:
           print "disconnecting events on selector"
           window.treeview.disconnect(window.treeview.eventid)
        
        if places_result.first_page: 
            window.first_button.set_sensitive(True)
        else:
            window.first_button.set_sensitive(False)
        if places_result.last_page:
            window.last_button.set_sensitive(True)
        else:
            window.last_button.set_sensitive(False)
        if places_result.next_page:
            window.next_button.set_sensitive(True)
        else:
            window.next_button.set_sensitive(False)
        if places_result.previous_page:
            window.previous_button.set_sensitive(True)
        else:
            window.previous_button.set_sensitive(False)
        
        window.store.clear()
        for place in places_result.places:
            print "Adding %s in selector" % place['title']
            if len(place['title'])<50:
                title = place['title']
            else:
                title = place['title'][0:50] + "..."
            label = "%s\n<small>%s km</small>" % (title,  place['distance'][0: -13])                        
            stars = gtk.gdk.pixbuf_new_from_file(MEDIA_PATH + 'star_4.png')
            window.store.append([label,  STARS[place['rating']]])
        print "disable selected item"
        
        window.treeview.eventid = window.treeview.connect("row-activated", self.place_selector_changed,  places_result.places)


    def category_selector_changed(self,  selector, user_data,  categories):
        print "category_selector_changed"
        current_selection = selector.get_current_text()
        print current_selection
        link = None
        if current_selection == 'Places':
            print "Go to places in category %s" % categories[0]['category_link']
            self.nearbyme_places_window(None,  categories[0]['category_link'])
        else:
            for category in  categories:
                if category['title'] == current_selection:     
                    if category['category_link'].isdigit():
                        print "Go to places in category %s" % category['category_link']
                        self.nearbyme_places_window(None,  category['category_link'])
                    else:
                        print "Go to subcategory %s" % category['category_link']
                        self.nearbyme_categories_window(None, category['category_link'])
                        link = category['category_link']


    def place_selector_changed(self, widget,  path,  view_column, places):
        print "place_selector_changed"
        window = hildon.StackableWindow()
        print path
        print path[0]
        print "Selected place : %s" % places[path[0]]['title']
        
        place = places[path[0]]
        print place
        
        address = ''
        if place['housenumber']: address = place['housenumber'] + " "
        if place['street']: address = address + place['street'] + "\n"
        if place['postcode']: address = address + place['postcode'] + " " + place['city']
        phone =''
        if place['phone']: phone = place['phone']
        
        table = gtk.Table(5,  2)        
        label = gtk.Label("Distance : ")
        label.set_alignment(0,  0)
        label.set_padding(40,  10)
        table.attach(label, 0,  1,  0,  1,  gtk.SHRINK)
        label = gtk.Label("Address : ")
        label.set_alignment(0,  0)
        label.set_padding(40,  10)
        table.attach(label, 0,  1,  1,  2,  gtk.SHRINK)
        label = gtk.Label("Phone : ")
        label.set_alignment(0,  0)
        label.set_padding(40,  10)
        table.attach(label, 0,  1,  2,  3,  gtk.SHRINK)
        label = gtk.Label("Opening hours : ")
        label.set_alignment(0,  0)
        label.set_padding(40,  10)
        table.attach(label, 0,  1,  3,  4,  gtk.SHRINK)
        
        distance = "%s km" % place['distance'][0: -13]
        label = gtk.Label(distance)
        label.set_alignment(0,  0)
        label.set_padding(0,  10)        
        table.attach(label, 1, 2,  0,  1)
        label = gtk.Label(address)
        label.set_alignment(0,  0)
        label.set_padding(0,  10)       
        table.attach(label, 1,  2,  1,  2)
        label = gtk.Label(phone)
        label.set_alignment(0,  0)
        label.set_padding(0,  10)       
        table.attach(label,  1,  2,  2,  3)
        label = gtk.Label(place['hours'])
        label.set_alignment(0,  0)
        label.set_padding(0,  10)       
        table.attach(label, 1,  2,  3,  4)
        
        vbox = gtk.VBox(False, 0)
        hbox = gtk.HBox(False, 0)
        label = gtk.Label()
        label.set_markup("<b>" + place['title'] + "</b>")
        hbox.pack_start(label, True, True, 0)
        hbox_star = gtk.HBox(False, 0)
        for x in range(int(place['rating'])):
            i = gtk.Image()
            i.set_from_file("/usr/share/qypy/star.png")
            hbox_star.pack_start(i,  False)
        hbox.pack_start(hbox_star,  False, False,   50);
        vbox.pack_start(hbox, True, True, 0)        
        vbox.pack_start(gtk.HSeparator(),  False,  False)        
        
        hbox = gtk.HBox(False, 0)

        toolbar = gtk.Toolbar()
        toolbar.set_orientation(gtk.ORIENTATION_VERTICAL)

        toolitem = gtk.ToolButton(gtk.image_new_from_file(CALL_ICON),
                                 "Call")
        if place['phone']:
            toolitem.connect("clicked", 
                        self.make_call, place['phone'].replace(' ', ''))
        else:
            toolitem.set_sensitive(False)
        toolbar.insert(toolitem, 0)
        
        toolitem = gtk.ToolButton(gtk.image_new_from_file(MAP_ICON),
                                 "Map")
        toolitem.connect("clicked",
                         self.view_gmap, place['latitude'], place['longitude'])
        toolbar.insert(toolitem, 1)

        hbox.pack_start(table, True, True, 0) 
        hbox.pack_start(toolbar, False, False, 0) 
        
        vbox.pack_start(hbox, True, True, 0) 
        
        print "setting window title"
        window.set_title("Qypy - Details")
        
        window.add(vbox)        
        window.show_all()
        
        
    def make_call(self, widget, phone):
        bus = dbus.SystemBus()
        csd_call = dbus.Interface(bus.get_object('com.nokia.csd',
                                            '/com/nokia/csd/call'),
                                            'com.nokia.csd.Call')
        csd_call.CreateWith(phone, dbus.UInt32(0))

        
    def quit(self,  control,  window,  widget):
        """Quit application"""
        gtk.main_quit()
        
        
    def warning_message(self,  exception, message):
        """"Display error dialog window"""
        
        if exception=='URLError':
            message = """Network error
            Check internet connection
            Or try later
            
            Internal error message :
            %s""" % message
        else:
            message = """Unknown error
            
            Internal error message :
            %s
            %s""" % (exception,  message)
        
        boite = gtk.Dialog("Error", self.window,
            gtk.DIALOG_MODAL,
            (gtk.STOCK_OK, gtk.RESPONSE_YES))
        msg_label = gtk.Label(message)
        msg_label.set_line_wrap(True)
        msg_label.set_size_request(-1, 300)
        boite.vbox.pack_start(msg_label, True, True, 0)
        boite.vbox.show_all()

        reponse = boite.run()
        boite.destroy()
        
        
    def gps_on_changed(self,  device,  user_data):
        """callback each time the location changes"""

        if device.fix:
            print self.previousfixtime,  device.fix[2]
            print str(device.fix[2])=='nan'
            if (str(device.fix[4]) != "nan") and (str(device.fix[5]) != "nan"):
                self.near_button.set_sensitive(True)
                self.latitude = device.fix[4]
                self.longitude = device.fix[5]
    
        
    def build_parameters_window(self,  widget,  data):
        dialog = gtk.Dialog("Parameters", self.window,
            gtk.DIALOG_MODAL,
            ('Save', gtk.RESPONSE_YES))
        dialog.set_title("Hello!")
        dialog.show_all()
        dialog.run()


    def view_gmap(self, widget, lat_place,  long_place):
        url = MAP_URL % (self.latitude,  self.longitude,  lat_place,  long_place)
        print url
        self.osso_r.rpc_run('com.nokia.osso_browser', 
                            '/com/nokia/osso_browser/request', 
                            'com.nokia.osso_browser', 
                            'load_url', (url, ),
                            False, True) 
                            
