/*
 * Copyright (C) 2015 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef QYOUTUBECLISTREAMS_H
#define QYOUTUBECLISTREAMS_H

#include <QObject>
#include <QVariantList>

namespace QYouTube {

class StreamsRequest;

class Streams : public QObject
{
    Q_OBJECT

public:
    explicit Streams(QObject *parent = 0);

    QString outputFormat() const;
    void setOutputFormat(const QString &format);

    void list(const QString &id);

private Q_SLOTS:
    void onRequestFinished();

Q_SIGNALS:
    void finished();

private:
    void printResult() const;
    
    StreamsRequest *m_request;

    QString m_format;
    QVariantList m_results;
};

}

#endif // QYOUTUBECLISTREAMS_H
