/*
 * Copyright (C) 2015 Stuart Howarth <showarth@marxoft.co.uk>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "streams.h"
#include <QCoreApplication>
#include <QStringList>
#include <iostream>

void printUsage() {
    std::cout << "Usage:\n\tqyoutube-streams-list [OPTION...] VIDEO_ID " \
    "List available video streams for a YouTube video.\n\n" \
    "Options:\n\t-output\tOutput format (html, json, tsv (default), xml).";
}

QString getParam(QStringList &args, const QString &name, const QString &defaultValue = QString()) {
    int i = args.indexOf(name);

    if ((i >= 0) && (i < args.size() - 1)) {
        args.removeAt(i);
        return args.takeAt(i);
    }

    return defaultValue;
}

int main(int argc, char *argv[]) {
    QCoreApplication app(argc, argv);
    app.setOrganizationName("QYouTube");
    app.setApplicationName("cli");

    QStringList args = app.arguments();

    if (args.size() < 2) {
	printUsage();
	return 1;
    }

    args.removeFirst();

    const QString output = getParam(args, "-output", "tsv");

    if (args.size() != 1) {
	printUsage();
	return 1;
    }

    QYouTube::Streams streams;
    streams.setOutputFormat(output);
    streams.list(args.takeFirst());
    QObject::connect(&streams, SIGNAL(finished()), &app, SLOT(quit()));
    
    return app.exec();
}
