import QtQuick 1.0
import QtWebKit 1.0

Component {
    id: listDelegate
    Item {
        property real detailsOpacity : 0
        id: wrapper; width: wrapper.ListView.view.width; height: if(txt.height > 60){txt.height+10}else{60} //50+5+5
        function handleLink(link){
            if(link.slice(0,3) == 'app'){
                screen.setUser(link.slice(7));
            }else if(link.slice(0,4) == 'http'){
                Qt.openUrlExternally(link);
            }
        }
        function addTags(str){
            var ret = str.replace(/@[a-zA-Z0-9_]+/g, '<a href="app://$&">$&</a>');//click to jump to user?
            var ret2 = ret.replace(/http:\/\/[^ \n\t]+/g, '<a href="$&">$&</a>');//surrounds http links with html link tags
            return ret2;
        }

        // Strip away paranthesis
        function userName(str) {
            var user = str.replace(/\([\S|\s]*\)/gi, "");
            return user.trim();
        }

        MouseArea {
            anchors.fill: parent
            onClicked: {
                // wrapper.state = 'Details';
                article.articleName = name;
                article.articleCurrent = name;
                fond.state="Parametrage"
                //mainArticle.loader.sourceComponent = mainArticle.webViewPage;
            }
        }

        Item {
            id: moveMe; height: parent.height
            /*      Rectangle {
                id: blackRect
                color: "black"; opacity: wrapper.ListView.index % 2 ? 0.2 : 0.3; height: wrapper.height-2; width: wrapper.width; y: 1
            } */
            Rectangle {
                id: blackRect
                //x: 2; y: 2; width: parent.width - x*2; height: parent.height - y*2
                // opacity: wrapper.ListView.index % 2 ? 0.2 : 0.3;
                //height: wrapper.height-2; width: wrapper.width; y: 1
                height: wrapper.height-1; width: wrapper.width; y: 0
                radius: 3
                gradient: Gradient {
                    GradientStop {
                        position: 0
                        color: "#000000" // "#7d7b97"
                    }
                    GradientStop {
                        position: 0.85
                        color: "#000000"
                    }
                    GradientStop {
                        position: 1
                        color: "#313f4d"
                    }
                }
            }

            Item {
                id: image; x: 6; width: 48; height: 48; smooth: true
                //anchors.verticalCenter: parent.verticalCenter

                Loading { x: 1; y: 1;
                    //width: 32; height: 32;
                    anchors.centerIn: parent;
                    visible: realImage.status != Image.Ready }

                Image {
                    id: realImage;
                    source: userImage == "" ? "qOp48.png" : userImage
                    x: 1; y: 5;
                    //width:48; height:48;
                    opacity:0 ;
                    // anchors.topMargin: 5
                    anchors.centerIn: parent

                    onStatusChanged: {
                        if(status==Image.Ready)
                            image.state="loaded"
                        if(status==Image.Error)
                            realImage.source="qOp48.png"
                    }
                }
                states: State {
                    name: "loaded";
                    PropertyChanges { target: realImage ; opacity:1 }
                }
                transitions: Transition { NumberAnimation { target: realImage; property: "opacity"; duration: 200 } }

            }
            Text { id:innerTxt ; text: name; opacity: 0 }
            Text { id:txt; y:4; x: 56
                text: '<html><style type="text/css">a:link {color:"#ffffff"}; a:visited {color:"#336633"}</style>'
                      + '<a href="app://@'+userName(name)+'"><b>'+userName(name) + '</b></a><br /><b style="font-size:small">' + statusText + "</b></html>";
                textFormat: Qt.RichText
                color: "#cccccc"; style: Text.Raised; styleColor: "black"; wrapMode: Text.WordWrap
                anchors.left: image.right; anchors.right: blackRect.right; anchors.leftMargin: 6; anchors.rightMargin: 6
                onLinkActivated: wrapper.handleLink(link)
            }
        }

        states: State {
            name: "Details"

            // PropertyChanges { target: blackRect; color: "#c0c0c0" }
            //PropertyChanges { target: recipeImage; width: 130; height: 130 } // Make picture bigger
            PropertyChanges { target: wrapper; detailsOpacity: 1; x: 0 } // Make details visible
            PropertyChanges { target: wrapper; height: wrapper.ListView.view.height } //lstRC.height } // Fill the entire list area with the detailed view

            // Move the list so that this item is at the top.
            PropertyChanges { target: wrapper.ListView.view; explicit: true; contentY: wrapper.y }

            // Disallow flicking while we're in detailed view
            PropertyChanges { target: wrapper.ListView.view; interactive: false }
        }

        transitions: Transition {
            // Make the state changes smooth
            ParallelAnimation {
                //ColorAnimation { property: "color"; duration: 500 }
                NumberAnimation { duration: 300; properties: "detailsOpacity,x,contentY,height,width" }
            }
        }

    }
}
