/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "ProgressWindow.h"

#include "SyncerThread.h"

#include <QProgressBar>
#include <QVBoxLayout>
#include <QWidget>

using namespace Windows;

ProgressWindow::ProgressWindow(Settings& settings, SyncerThread* syncThread, QWidget *parent) :
		BaseWindow(settings, parent)
{
	CreateContents(syncThread);
}

void ProgressWindow::CreateContents(SyncerThread* syncThread)
{
	switch(CurrentSettings().AppMode())
	{
		case Settings::APPMODE_GUI:
		{
			QVBoxLayout *layout = new QVBoxLayout();
			{
		//		QLabel* lblTest = new QLabel(CurrentSettings().Directory());
		//		layout->addWidget(lblTest);
		//		//layout->setAlignment(lblTest, Qt::AlignHCenter | Qt::AlignTop);

				m_ProgressBar = new QProgressBar(this);
				QObject::connect(syncThread, SIGNAL(EventProcessed(int,int)), this, SLOT(UpdateBar(int,int)));
				layout->addWidget(m_ProgressBar);
				//layout->setAlignment(btnChoose, Qt::AlignHCenter);

		//		layout->addWidget(new QLabel());

				centralWidget()->setLayout(layout);
			}

			break;
		}

		case Settings::APPMODE_CONSOLE:
		{
			break;
		}
	}
}

void ProgressWindow::UpdateBar(int message, int total)
{
	m_ProgressBar->setMaximum(total);
	m_ProgressBar->setValue(message);
}

void ProgressWindow::Advance()
{
	close();
}
