/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENT_H
#define EVENT_H

#include "iEvent.h"

#include <QList> // Needed for default value
class QString;

class _RTComElAttachment;
typedef _RTComElAttachment RTComElAttachment;
class _RTComElEvent;
typedef _RTComElEvent RTComElEvent;

class Attachment;
class NumberToNameLookup;

#include "iHashable.h"

namespace EventTypes
{
	class RtcomEvent : public iEvent
	{
	public:
		RtcomEvent();

		RtcomEvent(const RTComElEvent &event, const QList<RTComElAttachment *> attachments = QList<RTComElAttachment *>());

		virtual RTComElEvent * toRTComEvent(const NumberToNameLookup &numberToNameLookup) const = 0;
		static void freeRTComContents(RTComElEvent &event);

		const unsigned int GetFlagValue(const QString &value) const;
	};
}

#endif // EVENT_H
