/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef EVENTPARSERS_CSVSYMBIANEVENTLOGPARSER_H
#define EVENTPARSERS_CSVSYMBIANEVENTLOGPARSER_H

#include "EventFormats/SymbianEventLog.h"
#include "iEventParser.h"
#include "Settings.h"

#include <QHash>
class QChar;
class QFile;
class QString;
class QStringList;

namespace EventParsers
{
	class CSVSymbianEventLogParser : public iEventParser, public SymbianEventLog
	{
	public:
		typedef QHash<QString, int> ColumnIndicesHash;

		static iEventParser *IsValid(const Settings &currentSettings, QFile &eventFile);

		CSVSymbianEventLogParser(const Settings &currentSettings, const QString &filename);

		virtual EventTypes::EventFromFileList ParseFile(QFile &eventFile, const QList<unsigned int> &recordsToReturn);

	private:
		Settings::eDirection ReadDirection(const uint value);

	protected:
		const Settings &CurrentSettings() const { return m_Settings; }
		const StringsLookup &Strings() const { return m_Strings; }
		StringsLookup &Strings() { return m_Strings; }

	protected:
		void Strings(const StringsLookup &strings) { m_Strings = strings; }

	private:
		const Settings &m_Settings;
		StringsLookup m_Strings;
	};
}

#endif // EVENTPARSERS_CSVSYMBIANEVENTLOGPARSER_H
