/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef DBBACKENDS_RTCOMEVENTLOGGERCOMPONENTS_TRIGGERDISABLER_H
#define DBBACKENDS_RTCOMEVENTLOGGERCOMPONENTS_TRIGGERDISABLER_H

class Settings;

#include <QHash>
class QSqlDatabase;
#include <QString>

namespace DBBackends
{
	namespace RtcomEventLoggerComponents
	{
		class TriggerDisabler
		{
		public:
			TriggerDisabler(const Settings &settings);
			~TriggerDisabler();

			void Reenable();

		protected:
			const Settings &CurrentSettings() const { return m_Settings; }

			const QHash<QString, QString> &Triggers() const { return m_Triggers; }

			const bool Reenabled() const { return m_Reenabled; }

			void RestoreTriggers(QSqlDatabase &db);
			void UpdateGroupCache(QSqlDatabase &db);

		private:
			const Settings &m_Settings;

			QHash<QString, QString> &Triggers() { return m_Triggers; }
			QHash<QString, QString> m_Triggers;

			void Reenabled(bool reenabled) { m_Reenabled = reenabled; }
			bool m_Reenabled;
		};
	}
}

#endif // DBBACKENDS_RTCOMEVENTLOGGERCOMPONENTS_TRIGGERDISABLER_H
