/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#ifndef DBBACKENDS_RTCOMEVENTLOGGER_H
#define DBBACKENDS_RTCOMEVENTLOGGER_H

#include "iDBBackend.h"
#include "Settings.h"

class _RTComElAttachment;
typedef _RTComElAttachment RTComElAttachment;
class _RTComElEvent;
typedef _RTComElEvent RTComElEvent;
class _RTComEl;
typedef _RTComEl RTComEl;

template <typename T1> class QList;
class QString;
class QStringList;

#include <QHash>

namespace DBBackends
{
	namespace RtcomEventLoggerComponents { class TriggerDisabler; }

	class RtcomEventLogger : public iDBBackend
	{
	public:
		RtcomEventLogger(const Settings &settings);
		RtcomEventLogger(const Settings &settings, const EventTypes::RtcomEvent &event);

		virtual void PreInsert();
		virtual void Insert(EventTypes::iEvent &event, const NumberToNameLookup &numberToNameLookup);
		virtual void PostInsert();
		virtual void Process(EventProcessors::iEventProcessor &eventProcessor);

	protected:
		const Settings &CurrentSettings() const { return m_Settings; }

	protected:
		virtual EventTypes::iEvent *const CreateEvent(RTComElEvent &revent, QList<RTComElAttachment*> &rattachments);
		void ProcessService(EventProcessors::iEventProcessor &processor, const EventTypes::eEventTypes service, const RTComEl &el);

		virtual const QList<uint> &InsertedIDs() const { return m_InsertedIDs; }

	public:
		virtual void ClearInsertedIDs();

	private:
		void UpdateInsertedStorageTimes();
		void Reindex();
		QStringList IntsToStringList(QList<uint> &values);

		const Settings &m_Settings;

		QHash<EventTypes::eEventTypes, int> m_ServiceIDs;

		QList<uint> m_InsertedIDs;
		QList<uint> &InsertedIDs() { return m_InsertedIDs; }

		RtcomEventLoggerComponents::TriggerDisabler *m_TriggerDisabler;
	};
}

#endif // DBBACKENDS_RTCOMEVENTLOGGER_H
