/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "CellularRadio.h"

#include <QDebug>

#include <QtDBus>

#include <stdexcept>

const char * NOKIA_SERVICE_PHONE_SCC("com.nokia.phone.SSC");
const char * NOKIA_PATH_PHONE_SCC("/com/nokia/phone/SSC");
const char * NOKIA_IFACE_PHONE_SCC("com.nokia.phone.SSC");

bool CellularRadio::CurrentState()
{
	QDBusInterface nokiaPhone(NOKIA_SERVICE_PHONE_SCC, NOKIA_PATH_PHONE_SCC, NOKIA_IFACE_PHONE_SCC, QDBusConnection::systemBus());
	if (nokiaPhone.isValid())
	{
		QDBusReply<QString> isEnabledReply = nokiaPhone.call("get_modem_state");
		if(isEnabledReply.isValid())
		{
			bool isEnabled(isEnabledReply.value() == "online" || isEnabledReply.value() == "actvation_pending");
			qDebug() << (isEnabled ? "Enabled:\t\t" : "Not enabled:\t") << "Cellular";
			return isEnabled;
		}
		else
			qDebug() << isEnabledReply.error();
	}
	else
		qDebug() << nokiaPhone.lastError();

	throw std::runtime_error("Unable to query cellular modem state");
}

void CellularRadio::SetState(bool shouldRadioBeEnabled)
{
	QDBusInterface nokiaPhone(NOKIA_SERVICE_PHONE_SCC, NOKIA_PATH_PHONE_SCC, NOKIA_IFACE_PHONE_SCC, QDBusConnection::systemBus());
	if (nokiaPhone.isValid())
	{
		QDBusReply<void> disableModemReply = nokiaPhone.call("set_radio", shouldRadioBeEnabled);

		if(!disableModemReply.isValid())
			qDebug() << disableModemReply.error().message();
	}
	else
		qDebug() << nokiaPhone.lastError().message();
}
