/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "Windows/ModeWindow.h"
#include "Windows/TypesWindow.h"
#include "Windows/ProgressWindow.h"

#include "SyncerThread.h"

#include <QtGui>

using namespace Windows;

ModeWindow::ModeWindow(Settings& settings, QWidget *parent) :
	BaseWindow(settings, parent)
{
	CreateContents();
}

void ModeWindow::CreateContents()
{
	switch(CurrentSettings().AppMode())
	{
		case Settings::APPMODE_GUI:
		{
			QVBoxLayout *layout = new QVBoxLayout();
			{
				QLabel* lblTest = new QLabel(CurrentSettings().Directory());
				layout->addWidget(lblTest);
				//layout->setAlignment(lblTest, Qt::AlignHCenter | Qt::AlignTop);

				QPushButton* btnImport = new QPushButton(QIcon(":/resources/sphone.png"), "Import");
				QObject::connect(btnImport, SIGNAL(clicked()), this, SLOT(Import()));
				layout->addWidget(btnImport);
				layout->setAlignment(btnImport, Qt::AlignHCenter);

				QPushButton* btnExport = new QPushButton(QIcon(":/resources/sphone.png"), "Export");
				QObject::connect(btnExport, SIGNAL(clicked()), this, SLOT(Export()));
				layout->addWidget(btnExport);
				layout->setAlignment(btnExport, Qt::AlignHCenter);

				layout->addWidget(new QLabel());

				centralWidget()->setLayout(layout);
			}

			break;
		}

		case Settings::APPMODE_CONSOLE:
		{
			// Process args.

			Advance();
			break;
		}
	}
}

void ModeWindow::Import()
{
	CurrentSettings().setMode(Settings::MODE_IMPORT);
	CurrentSettings().setDirectory("IMPORT");
	Advance();
}

void ModeWindow::Export()
{
	CurrentSettings().setMode(Settings::MODE_EXPORT);
	CurrentSettings().setDirectory("EXPORT");
	Advance();
}

void ModeWindow::Advance()
{
	QWidget* next = new TypesWindow(CurrentSettings(), this);
	next->show();
}

void ModeWindow::closeEvent(QCloseEvent *)
{
	if(CurrentSettings().IsConfirmed())
	{
		SyncerThread* tSync = new SyncerThread(CurrentSettings());
		QWidget* progressWindow = new ProgressWindow(CurrentSettings(), tSync);
		progressWindow->show();

		tSync->Sync();
	}
}
