/*
 * Copyright (C) 2011, Jamie Thompson
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; If not, see
 * <http://www.gnu.org/licenses/>.
 */

#include "VCalendar.h"

#include "Attachment.h"
#include "Factory.h"
#include "EventTypes/SMS.h"
#include "VBody.h"
#include "VEnvelope.h"
#include "VMessage.h"

#include <QDebug>
#include <QDir>
#include <QTextStream>
#include <QTemporaryFile>

#include <glib.h>

#include <rtcom-eventlogger/eventlogger.h>

#include <typeinfo>

using namespace EventParsers::VMGEntities;

VCalendar::VCalendar(const SMSEntity* parent) :
	SMSEntity(parent), m_Version(1.0)
{
}

//VCalendar::VCalendar(QTextStream& stream)
//{
//}

VCalendar::VCalendar(const SMSEntity* parent, float version) :
	SMSEntity(parent), m_Version(version)
{
}

VCalendar::~VCalendar()
{
}

void VCalendar::Write(QTextStream &stream, const EventTypes::SMS &event)
{
	//stream << "BEGIN:" << getTagName() << "\n";

	//stream << "VERSION:" << m_Version << "\n";
	//stream << "N:" << (m_Target == VCARD_LOCAL ? "" : event.Name()) << "\n";
	//stream << "TEL:" << (m_Target == VCARD_LOCAL ? "" : event.Tel()) << "\n";

	//stream << "END:" << getTagName() << "\n";
}

bool VCalendar::Read(const QString &initialLine, QTextStream &stream, EventTypes::SMS &event)
{
	bool hasEnded(false);
	float version(0);
	bool isTopLevel(typeid(*getParent()) == typeid(VMessage));
	bool isSender(typeid(*getParent()) == typeid(VEnvelope));
	Attachment *vCalendarAttachment;

	if(isAttachment())
	{
		vCalendarAttachment = new Attachment(
			(QDir::tempPath() + "/attachment-" + QString::number(event.Timestamp().toTime_t()) + "-" + QString::number(event.Attachments().count()) + ".vcalendar").toUtf8(),
			"text/x-vcalendar");
	}

	// Stream may or may not have a 'BEGIN' present. Swallow it if it's ours.
	QString lineData(initialLine.length() > 0 ? initialLine : stream.readLine());
	if(lineData.startsWith("BEGIN:"))
	{
		if(lineData != QString("BEGIN:") + getTagName())
		{
			qDebug() << "Invalid stream";
			return false;
		}
		else if(!isAttachment())
		{
			// ...discard this line
			lineData = stream.readLine();
		}
	}

	do
	{
		if(isAttachment())
		{
			vCalendarAttachment->Stream() << lineData << endl;

			if(lineData.startsWith("END:"))
			{
				if(lineData == QString("END:VTODO")
					|| lineData == QString("END:VEVENT"))
				{
					// Ignore these. We treat these nested structures as content
				}
				else if(lineData != QString("END:") + getTagName())
				{
					qDebug() << getTagName() << " parser mismatch error" << lineData;
					break;
				}
				else
				{
					// Save attachment
					event.Attachments().append(vCalendarAttachment);

					hasEnded = true;
					break;
				}
			}
		}
		else
		{
			if(lineData.startsWith("VERSION:"))
			{
				version = lineData.mid(lineData.indexOf(":")+1).toFloat();
			}
			else if(lineData.startsWith("BEGIN:"))
			{
				iReader* reader = Factory::Instantiate(lineData, this);
				bool valid(NULL != reader && reader->Read(lineData, stream, event));
				delete reader;

				// Quit processing if the nested content is not valid
				if(!valid)
					return valid;
			}
			else if(lineData.startsWith("END:"))
			{
				if(lineData != QString("END:") + getTagName())
				{
					qDebug() << getTagName() << " parser mismatch error" << lineData;
					break;
				}
				else
				{
					hasEnded = true;
					break;
				}
			}
		}

		lineData = stream.readLine();
	}while(!hasEnded && !stream.atEnd());

	if(hasEnded)
	{

	}

	return true;
}
