/*
 * QEnmlParser.h
 *
 *  Created on: May 17, 2010
 *      Author: alexr
 */

#ifndef QENMLREADER_H_
#define QENMLREADER_H_

#include <QXmlSimpleReader>
#include <QXmlInputSource>
#include <QXmlDefaultHandler>
#include <Limits_constants.h>
#include "QvernoteAPI.h"
#include <QDebug>



class QEnmlContentHandler : public QXmlDefaultHandler {
	enum EnmlElement {
		EN_NOTE,
		EN_MEDIA,
		EN_CRYPT,
		EN_TODO,
		EN_NONE
	};

	enum EnmlMediaType {
		MT_IMAGE,
		MT_AUDIO,
		MT_PDF,
		MT_INK,
		MT_APPLICATION,
		MT_UNKNOWN = 100
	};

	enum EnmlContentType {
		CT_HTML,
		CT_MEDIA,
		CT_NONE
	};

public:
	QEnmlContentHandler(const Note& note, int maxHtmlSize = 0)
	: m_Note(note),
	  currentEnmlContentType(CT_NONE),
	  isHtmlElementOpened(false),
	  m_hEvernote(QvernoteAPI::Instance()),
	  m_nTodoCount(0),
	  m_maxHtmlSize(maxHtmlSize) { };
	~QEnmlContentHandler() { };

	bool startElement( const QString & namespaceURI, const QString & localName, const QString & , const QXmlAttributes & atts );
	bool endElement ( const QString & namespaceURI, const QString & localName, const QString &  );
	bool characters ( const QString & ch );
	bool startDocument () { m_sOutputHtml = "<html><body>";  return true; }
	bool endDocument () { m_sOutputHtml += "</body></html>"; /*qDebug() << __FUNCTION__ << m_sOutputHtml;*/ return true; }
	QString	getHtml() { return m_sOutputHtml; }
	int getTodoCount() { return m_nTodoCount; }

	void setMaxHtmlSize(int maxHtmlSize) { m_maxHtmlSize = maxHtmlSize; }
private:
	EnmlElement decodeEnmlElement(const QString& elemName);
	EnmlMediaType decodeEnmlMediaType(const QXmlAttributes & atts, QString& htmlTag);
	int decodeResource(const QXmlAttributes & atts, QByteArray& bodyData, QString& fileName);

	void openHtmlElement(const QString& elemName, const QXmlAttributes & atts);
	void closeHtmlElement(const QString& elemName);
	void addMedia(const QXmlAttributes & atts);

	void openTodoElement(const QXmlAttributes & atts);

	void appendCharacterData(const QString& ch, QString& htmlData);


private:
	Note m_Note;
	QString m_sOutputHtml;
	EnmlElement	currentEnmlElement;
	EnmlContentType currentEnmlContentType;
	bool	isHtmlElementOpened;
	QvernoteAPI* m_hEvernote;
	int m_nTodoCount;
	int m_maxHtmlSize;
};

class QEnmlReader : public QXmlSimpleReader {
public:
	QEnmlReader(const Note& note);
	QEnmlReader() {}
	virtual ~QEnmlReader();

	bool parse(int maxHtmlSize = 0);
	bool parse(const Note& note, int maxHtmlSize = 0);
	QString getHtml() { return ((QEnmlContentHandler*)contentHandler())->getHtml(); }
	int getTodoCount() { return ((QEnmlContentHandler*)contentHandler())->getTodoCount(); }

private:
	QXmlInputSource m_EnmlDocumentInputSource;
	shared_ptr<QEnmlContentHandler> m_EnmlContentHandler;
};


#endif /* QENMLREADER_H_ */
