/*
 * QPopplerSupport.h
 *
 *  Created on: Aug 2, 2010
 *      Author: alexr
 */

#ifndef QPOPPLERSUPPORT_H_
#define QPOPPLERSUPPORT_H_

#include <poppler-qt4.h>
#include <QDebug>

class QPopplerSupport
{
public:
	QPopplerSupport(QByteArray& pdfData) {
		document = Poppler::Document::loadFromData(pdfData);

		if(!document || document->isLocked()) {
			qDebug() << "Error loading PDF document";
			delete document;
		}
	}

	~QPopplerSupport() {
		delete document;
	}

	void renderPage(int pageNumber, QPixmap& pixmap) {
		if(!document) {
			renderNullPage(pixmap);
			return;
		}

		Poppler::Page* pdfPage = document->page(pageNumber);
		if(pdfPage == NULL) {
			renderNullPage(pixmap);
			return;
		}

		pixmap = QPixmap::fromImage(pdfPage->renderToImage());
	}

private:
	void renderNullPage(QPixmap& pixmap) {
		QString invalidPdf = "Invalid PDF";
		QPainter p(&pixmap);
		int strWidth = p.fontMetrics().width(invalidPdf);

		p.drawPixmap(pixmap.width() / 2 - 24, 10, QPixmap(":/IconAdd/file-pdf.png"));
		p.drawText(pixmap.width() / 2 - strWidth / 2, 80, invalidPdf);
	}

private:
	Poppler::Document* document;
};
#endif /* QPOPPLERSUPPORT_H_ */
