#ifndef QVERNOTE_H
#define QVERNOTE_H

#include <QtGui/QMainWindow>
#include "ui_QvernoteView.h"
#include "QvernoteWindow.h"
#include "QvernoteAPI.h"
#include "QNotesView.h"
#include "QNotebookListItemWidget.h"
#include "QSyncProgressDialog.h"
#include "QSyncProgressWidget.h"



class QvernoteView : public QvernoteWindow
{
    Q_OBJECT

public:
    QvernoteView(QWidget *parent = 0);
    ~QvernoteView();

    void keyPressEvent(QKeyEvent* event);

public slots:
	void initView();
	void loadNotebook(QListWidgetItem* p_notebookListItem);
    void createNewNotebook();
    void synchronizeNoteStore();
    void reloadNotebookList();
    void loadNotebookList(QString notebookFilter = "");
    void deleteSelectedNotebook(QNotebookListItemWidget*);
    void openSearchDialog();
    void searchNote(QString searchString);
    void openDeleteNotebookWindow();
    void openAboutDialog();
    void openTrashWindow();
    void openOptionsDialog();
    void redrawNotebookList(QString searchString);
    void showSyncProgressInfo(QString);
    void clearNotebookList();

    void orientationChanged();
    bool backgroundJobCallback() { return backgroundInit(); }
    void jobDoneCallback() { loadNotebookList(); }
    void jobFailedCallback() { displayError("Unable to load notebook list", QString(m_hEvernote->getLastErrorString().c_str())); }

signals:
	void progressDataUpdated(QString);

private:
	bool backgroundInit();

private:
    Ui::QvernoteClass ui;
    QvernoteAPI* m_hEvernote;
    QNotesView*		m_pNotesView;
    QSyncProgressDialog syncDlg;
    QSyncProgressWidget syncWidget;
    bool	isSearchShown;
    bool 	isSynchronizing;
};

#endif // QvernoteView_H
