#include "QNotesView.h"
#include "QNoteEditWindow.h"
#include <QPropertyAnimation>
#include <QDebug>
#include <QGraphicsPixmapItem>
#include <QGraphicsView>
#include <QPixmap>
#include <QMessageBox>
#include <QGraphicsProxyWidget>
#include <QGraphicsGridLayout>
#include "QNoteListItemWidget.h"
#include "QDeleteNotesView.h"
#include "QNoteViewWindow.h"
#include "QKeyGrabber.h"
#include "QNoteListView.h"
#include "QNoteGridView.h"

QNotesView::QNotesView(const Notebook& notebook, QWidget *parent)
    : QvernoteWindow(parent), m_hEvernote(QvernoteAPI::Instance()), m_Notebook(notebook), isSearchShown(false), isSynchronizing(false)
{
	ui.setupUi(this);

	this->setWindowTitle(QString(notebook.name.c_str()));

	switch(QvernoteSettings::Instance()->getNotesView()) {
	case QvernoteSettings::NV_LIST:
		m_pNoteListViewWidget = new QNoteListView(this);
		break;
	case QvernoteSettings::NV_GRID:
		m_pNoteListViewWidget = new QNoteGridView(m_Notebook.guid, this);
		break;
	default:
		break;
	}

	ui.gridLayout_2->addWidget(dynamic_cast<QWidget*>(m_pNoteListViewWidget), 1, 0, 1, 2);
	ui.gridLayout_2->setAlignment(Qt::AlignTop);


	QObject::connect(ui.actionReload, SIGNAL(triggered(bool)), this, SLOT(reloadNotes()));
	QObject::connect(ui.pbNewNote, SIGNAL(clicked()), this, SLOT(openNewNoteWindow()));
	//QObject::connect(ui.lvNoteList, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(openNoteEditor(QListWidgetItem *)));
	//QObject::connect(ui.lvNoteList, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(openNoteViewer(QListWidgetItem *)));

	QObject::connect(ui.actionDelete_notes, SIGNAL(triggered(bool)), this, SLOT(loadDeleteNotesView()));

	setProgressIndicator(true);
	m_pBackgroundJob->start();
	displayInformationBox("Loading notes. Please wait...");
}


QNotesView::QNotesView(QString windowTitle, QWidget *parent)
: QvernoteWindow(parent), m_hEvernote(QvernoteAPI::Instance()), isSearchShown(false), isSynchronizing(false)
{
	ui.setupUi(this);

	this->setWindowTitle(windowTitle);
	ui.pbNewNote->setVisible(false);

	switch(QvernoteSettings::Instance()->getNotesView()) {
	case QvernoteSettings::NV_LIST:
		m_pNoteListViewWidget = new QNoteListView(this);
		break;
	case QvernoteSettings::NV_GRID:
		m_pNoteListViewWidget = new QNoteGridView(m_Notebook.guid, this);
		break;
	default:
		break;
	}

	ui.gridLayout_2->addWidget(dynamic_cast<QWidget*>(m_pNoteListViewWidget), 1, 0, 1, 2);
	loadNotesIntoView();
}

QNotesView::~QNotesView()
{

}

void QNotesView::reloadNotes()
{
	m_pBackgroundJob->start();
}

void QNotesView::loadNotesIntoView(QString noteFilter)
{
	isSynchronizing = true;
	m_pNoteListViewWidget->redrawNotes(noteFilter);
}

void QNotesView::openNewNoteWindow()
{
	Note newNote;// = new Note();
	newNote.notebookGuid = m_Notebook.guid;
	QNoteEditWindow* pNoteEditWindow = new QNoteEditWindow(newNote, true, NULL, this);
	QObject::connect(pNoteEditWindow, SIGNAL(noteListUpdated()),this, SLOT(loadNotesIntoView()));
	pNoteEditWindow->show();
}

/*
void QNotesView::openNoteEditor(QListWidgetItem *item)
{
	QNoteListItemWidget* w = (QNoteListItemWidget*)ui.lvNoteList->itemWidget(item);

	//QNoteEditWindow* pNoteEditWindow = new QNoteEditWindow(w->getNote(), w->getHtml(), m_hEvernote, this);
	//pNoteEditWindow->show();
	openNoteEditor(w->getNote());
}
*/
/*
void QNotesView::openNoteEditor(QNoteListItemWidget *item)
{
	//QNoteEditWindow* pNoteEditWindow = new QNoteEditWindow(item->getNote(), false, m_hEvernote, 0, this);
	//pNoteEditWindow->show();
	openNoteEditor(item->getNote());
}
*/
void QNotesView::openNoteEditor(Note& note, QEnmlReader* reader)
{
	QNoteEditWindow* pNoteEditWindow = new QNoteEditWindow(note, false, reader, this);
	pNoteEditWindow->show();
}

void QNotesView::openNoteViewer(Note& note)
{
	QNoteViewWindow* pWnd = new QNoteViewWindow(note, this);
	connect(pWnd, SIGNAL(startEditorSignal(Note&, QEnmlReader*)), this, SLOT(openNoteEditor(Note&, QEnmlReader*)));
	pWnd->show();
}

void QNotesView::getNextNote(Note& nextNote)
{
	//QList<QListWidgetItem*> l = ui.lvNoteList->selectedItems();
	//QListWidgetItem* nextItem = ui.lvNoteList->item(ui.lvNoteList->row(l[0]) + 1);


	if(m_pNoteListViewWidget->nextNote(nextNote) == false)
	{
		displayInformationBox("This is the last note");
	}
	/*else
	{
		//QNoteListItemWidget* w = (QNoteListItemWidget*)ui.lvNoteList->itemWidget(nextItem);
		//ui.lvNoteList->setItemSelected(nextItem, true);
		//nextNote = w->getNote();
	}
	*/
}

void QNotesView::getPrevNote(Note& prevNote)
{
	//QList<QListWidgetItem*> l = ui.lvNoteList->selectedItems();

	if(m_pNoteListViewWidget->prevNote(prevNote) == false)
	{
		displayInformationBox("This is the first note");
	}

	/*
	else
	{
		QListWidgetItem* prevItem = ui.lvNoteList->item(ui.lvNoteList->row(l[0]) - 1);
		ui.lvNoteList->setItemSelected(prevItem, true);
		QNoteListItemWidget* w = (QNoteListItemWidget*)ui.lvNoteList->itemWidget(prevItem);
		prevNote = w->getNote();
	}
	*/
}

void QNotesView::loadDeleteNotesView()
{
	QDeleteNotesView* p_Wnd = new QDeleteNotesView(QString(m_Notebook.name.c_str()), this);
	p_Wnd->show();
}

void QNotesView::notesViewShutdown()
{
	displayError("Error loading notebook", QString(m_hEvernote->getLastErrorString().c_str()));
	close();
}

bool QNotesView::queryNotes()
{
	bool retVal;
	isSynchronizing = true;
	retVal =- m_hEvernote->loadNotes(100000, m_Notebook);
	return retVal;
}

void QNotesView::clearNote(Note& m_Note)
{
	//qDebug() << "Delete note content";

	m_Note.content.clear();
	m_Note.content.reserve(0);
	m_Note.tagNames.clear();
	m_Note.tagGuids.clear();
	for(vector<Resource>::iterator i = m_Note.resources.begin(); i != m_Note.resources.end(); i++)
	{
		(*i).data.body.clear();
		(*i).data.body.reserve(0);
		(*i).recognition.body.clear();
		(*i).alternateData.body.clear();
	}
}

void QNotesView::keyPressEvent(QKeyEvent* event)
{
	if(!isSearchShown && !isSynchronizing)
	{
		QKeyGrabber* dlg = new QKeyGrabber(event->text(), this);
		ui.gridLayout->addWidget(dlg, 2, 0);
		QObject::connect(dlg, SIGNAL(redrawParentContents(QString)), this, SLOT(redrawNoteList(QString)));
		isSearchShown = true;
	}

	QvernoteWindow::keyPressEvent(event);
}

void QNotesView::redrawNoteList(QString searchString)
{
	//qDebug() << __FUNCTION__ << searchString;
	if(searchString.isEmpty())
		isSearchShown = false;

	loadNotesIntoView(searchString);
}

void QNotesView::onNoteLoadProgress()
{
	ui.scrollArea->ensureVisible(0, ui.scrollAreaWidgetContents->geometry().height() + 100);
}

void QNotesView::onNoteLoadDone()
{
	ui.scrollArea->ensureVisible(0, 0);
	setProgressIndicator(false);
	isSynchronizing = false;
}

void QNotesView::orientationChanged()
{
	loadNotesIntoView();
}
