/*
 * QNotebookPickList.h
 *
 *  Created on: Jun 30, 2010
 *      Author: alexr
 */

#ifndef QNOTEBOOKPICKLIST_H_
#define QNOTEBOOKPICKLIST_H_

#include <QDialog>
#include <QScrollArea>
#include <QVBoxLayout>
#include <QGridLayout>
#include <QPushButton>
#include "QvernoteAPI.h"



class QNotebookButton : public QPushButton
{
	Q_OBJECT

public:
	QNotebookButton(QString notebookName, QString notebookGuid, QWidget* parent = 0) : QPushButton(parent) {
		m_notebookName = notebookName;
		m_notebookGuid = notebookGuid;
		setText(m_notebookName);
		QObject::connect(this, SIGNAL(clicked()), SLOT(notebookSelected()));
	}

	QString getNotebookName() { return m_notebookName; }
	QString getNotebookGuid() { return m_notebookGuid; }

public slots:
	void notebookSelected() {
		emit sendNotebookInfo(m_notebookName, m_notebookGuid);
	}

signals:
	void sendNotebookInfo(QString, QString);
private:
	QString m_notebookName;
	QString m_notebookGuid;
};

class QNotebookPickList : public QDialog
{
	Q_OBJECT

public:
	QNotebookPickList(QString currentNotebookName, QWidget* parent = 0) : QDialog(parent) {
		QvernoteAPI* api = QvernoteAPI::Instance();
		Notebook notebook;
		QNotebookButton* notebookButton;
		bool hasMoreItems;
		mainLayout = new QGridLayout(this);
		layout = new QVBoxLayout(&w);

		setWindowTitle("Choose notebook");

		for(hasMoreItems = api->getFirstNotebook(notebook); hasMoreItems; hasMoreItems = api->getNextNotebook(notebook)) {
			if(currentNotebookName != QString::fromStdString(notebook.name)) {
				notebookButton = new QNotebookButton(QString::fromStdString(notebook.name), QString::fromStdString(notebook.guid), this);
				QObject::connect(notebookButton, SIGNAL(sendNotebookInfo(QString, QString)), this, SLOT(notebookGuidSelected(QString, QString)));
				layout->addWidget(notebookButton);
			}
		}

		area.setWidget(&w);
		area.setWidgetResizable(true);
		mainLayout->addWidget(&area);
	}

	QSize sizeHint() const {
		return QSize(800, 70*5);
	}

	QString getSelectedGuid() { return m_selectedGuid; }
	QString getSelectedName() { return m_selectedName; }

public slots:
	void notebookGuidSelected(QString notebookName, QString notebookGuid) {
		m_selectedName = notebookName;
		m_selectedGuid = notebookGuid;
		done(QDialog::Accepted);
		//close();
	}

private:
	QScrollArea area;
	QWidget w;
	QVBoxLayout* layout;
	QGridLayout* mainLayout;
	QString m_selectedGuid;
	QString m_selectedName;
};

#endif /* QNOTEBOOKPICKLIST_H_ */
