#ifndef QVERNOTE_H
#define QVERNOTE_H

#include <QtGui/QMainWindow>
#include "ui_QvernoteView.h"
#include "QvernoteWindow.h"
#include "QvernoteAPI.h"
#include "QNotesView.h"
#include "QNotebookListItemWidget.h"
#include "QSyncProgressDialog.h"
#include "QSyncProgressWidget.h"

using namespace qvernote::api;

class QvernoteView : public QvernoteWindow
{
    Q_OBJECT

public:
    QvernoteView(QWidget *parent = 0);
    ~QvernoteView();

public slots:
	void initView();
	void loadNotebook(QListWidgetItem* p_notebookListItem);
    void createNewNotebook();
    void synchronizeNoteStore();
    void reloadNotebookList();
    void loadNotebookList();
    void deleteSelectedNotebook(QNotebookListItemWidget*);
    void configureSslProtocol(bool checked);
    void configureOnlineMode(bool checked);
    void accountConfig();
    void openSearchDialog();
    void searchNote(QString searchString);
    void openDeleteNotebookWindow();
    void openAboutDialog();
    void openTrashWindow();

    void showSyncProgressInfo(QString);

    void setPortraitOrientation(bool) { setDisplayOrientation(QvernoteSettings::DO_PORTRAIT); }
    void setLandscapeOrientation(bool) { setDisplayOrientation(QvernoteSettings::DO_LANDSCAPE); }
    void setAutoOrientation(bool) { setDisplayOrientation(QvernoteSettings::DO_AUTO); }

    void orientationChanged();
    bool backgroundJobCallback() { return backgroundInit(); }
    void jobDoneCallback() { loadNotebookList(); }
    void jobFailedCallback() { displayError("Unable to load notebook list", QString(m_hEvernote->getLastErrorString().c_str())); }

signals:
	void progressDataUpdated(QString);

private:
	bool backgroundInit();

private:
    Ui::QvernoteClass ui;
    QvernoteAPI* m_hEvernote;
    QNotesView*		m_pNotesView;
    QSyncProgressDialog syncDlg;
    QSyncProgressWidget syncWidget;
};

#endif // QvernoteView_H
