/*
 * QvernoteStorageQueries.h
 *
 *  Created on: Jun 13, 2010
 *      Author: alexr
 */

#ifndef QVERNOTESTORAGEQUERIES_H_
#define QVERNOTESTORAGEQUERIES_H_

#define PREPARE_NOTEBOOK_SCRIPT	\
	"create table notebooks ( " \
		"dirty integer default 0, " \
		"deleted integer default 0," \
		"guid varchar(255) unique primary key not null, " \
		"name TEXT, " \
		"updateSequenceNum integer default 0, "\
		"defaultNotebook smallint, " \
		"serviceCreated integer, " \
		"serviceUpdated integer, " \
		"published integer )"

#define PREPARE_NOTE_SCRIPT \
	"create table notes ( " \
			"dirty integer default 0, " \
			"guid varchar(255) unique primary key not null, " \
			"title TEXT, " \
			"content CBLOB, " \
			"contentHash varchar(64), " \
			"contentLength integer, " \
			"created integer, " \
			"updated integer, " \
			"deleted integer default 0, " \
			"active integer, " \
			"updateSequenceNum integer default 0, " \
			"notebookGuid varchar(255), " \
			"foreign key (notebookGuid) references notebooks(guid) ON DELETE CASCADE ON UPDATE CASCADE)"

#define PREPARE_TAG2NOTE_SCRIPT \
	"create table notetags ( " \
			"tagid varchar(255), " \
			"noteid varchar(255), " \
			"foreign key (tagid) references tags(guid) ON DELETE CASCADE ON UPDATE CASCADE, " \
			"foreign key (noteid) references notes(guid) ON DELETE CASCADE ON UPDATE CASCADE)"

#define PREPARE_NOTE_ATTRIB_SCRIPT \
	"create table noteattributes ( " \
			"noteid varchar(255), " \
			"subjectDate integer, " \
			"latitude real, " \
			"longitude real, " \
			"altitude real, " \
			"author varchar(255), " \
			"source varchar(255), " \
			"sourceURL varchar(255), " \
			"sourceApplication varchar(255)," \
			"foreign key (noteid) references notes(guid) ON DELETE CASCADE ON UPDATE CASCADE)"

#define PREPARE_TAG_SCRIPT \
	"create table tags ( " \
			"dirty integer default 0, " \
			"deleted integer default 0," \
			"guid varchar(255) unique primary key not null, " \
			"name varchar(255), " \
			"parentGuid varchar(255), " \
			"updateSequenceNum integer default 0 )"

#define PREPARE_SAVEDSEARCH_SCRIPT \
	"create table savedsearches ( " \
			"dirty integer default 0, " \
			"guid varchar(255) primary key not null, " \
			"name varchar(255), " \
			"query varchar(255), " \
			"format integer, " \
			"updateSequenceNum integer default 0 )"

#define PREPARE_RESOURCE_SCRIPT \
	"create table resources ( " \
			"dirty integer default 0, " \
			"guid varchar(255) unique primary key not null, " \
			"noteGuid varchar(255), " \
			"mime varchar(255), " \
			"width integer, " \
			"height integer, " \
			"duration integer, " \
			"active integer , " \
			"updateSequenceNum integer default 0, " \
			"foreign key (noteGuid) references notes(guid) ON DELETE CASCADE ON UPDATE CASCADE)"
			//"foreign key (active) references notes(active) ON UPDATE CASCADE)"

/*
 * Data can be of types:
 *
 * Resource = 0
 * Recognition = 1
 * Alternate = 2
 */

typedef enum eResourceDataType {
	DT_Resource = 0,
	DT_Recognition = 1,
	DT_Alternate = 2
} ResourceDataType;

#define PREPARE_DATATAB_SCRIPT \
	"create table data ( " \
			"resourceid varchar(255), " \
			"type integer, "		\
			"bodyHash varchar(255), " \
			"size integer, " \
			"body BLOB, " \
			"foreign key (resourceid) references resources(guid) ON DELETE CASCADE ON UPDATE CASCADE)"

#define PREPARE_RESOURCE_ATTRIB_SCRIPT \
	"create table resourceattrib ( " \
			"resourceid varchar(255), " \
			"sourceURL varchar(255), " \
			"timestamp integer, " \
			"latitude real, " \
			"longitude real, " \
			"altitude real, " \
			"cameraMake varchar(255), " \
			"cameraModel varchar(255), " \
			"clientWillIndex integer, " \
			"fileName varchar(255), " \
			"attachment integer, "\
			"foreign key (resourceid) references resources(guid) ON DELETE CASCADE ON UPDATE CASCADE)"


#endif /* QVERNOTESTORAGEQUERIES_H_ */
