#include "QTagSelectorDialog.h"
#include "QClickableLabel.h"
#include <QMessageBox>
#include <QDebug>
#include "QTagButton.h"
#include "QvernoteWindow.h"
#include "QNewTagDialog.h"
#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>
#include <QDesktopWidget>
#endif

QTagSelectorDialog::QTagSelectorDialog(QvernoteAPI* hEvernote, const Note& note, QWidget *parent)
    : QDialog(parent), m_vTagNames(note.tagNames), m_hEvernote(hEvernote)
{
	ui.setupUi(this);

	if(note.title.empty())
	{
		this->setWindowTitle("Tags for Untitled");
	}
	else
	{
		this->setWindowTitle("Tags for " + QString::fromStdString(note.title));
	}

	QObject::connect(ui.pbNewTag, SIGNAL(clicked()), this, SLOT(addNewTag()));
	QObject::connect(ui.pbDone, SIGNAL(clicked()), this, SLOT(close()));

	if(m_hEvernote->loadTagList() == false)
	{
#ifdef Q_WS_MAEMO_5
		QMaemo5InformationBox::information(this, "Error loading tag list: " + QString(m_hEvernote->getLastErrorString().c_str()), QMaemo5InformationBox::DefaultTimeout);
#else
		QMessageBox::critical(this, "Error loading tag list", QString(m_hEvernote->getLastErrorString().c_str()));
#endif
	}

	loadTagsIntoView();
}

QTagSelectorDialog::~QTagSelectorDialog()
{

}

void QTagSelectorDialog::addTag(Tag& tag)
{
	QTagButton* tagLabel;

	tagLabel = new QTagButton(tag, ui.saTagArea->widget());
	tagLabel->adjustGeometry(geom);
	tagLabel->show();

	if(std::find(m_vTagNames.begin(), m_vTagNames.end(), tag.name) != m_vTagNames.end())
	{
		tagLabel->setChecked(true);
	}

	connect(tagLabel, SIGNAL(tagToggled(bool, Tag)), /*m_parent*/this->parentWidget(), SLOT(setTag(bool, Tag)));
}

void QTagSelectorDialog::loadTagsIntoView()
{
	bool hasMoreItems;
	//QTagButton* tagLabel;
	Tag tag;

	for(hasMoreItems = m_hEvernote->getFirstTag(tag); hasMoreItems; hasMoreItems = m_hEvernote->getNextTag(tag))
	{
		addTag(tag);
	}
}

void QTagSelectorDialog::addNewTag()
{
	QNewTagDialog* pDlg = new QNewTagDialog();
	pDlg->exec();

	if(pDlg->getTagName().isEmpty())
		return;

	Tag newTag;

#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5ShowProgressIndicator, true);
#endif
	if(m_hEvernote->addNewTag(pDlg->getTagName().toStdString(), newTag) == true)
	{
		addTag(newTag);
	}
	else
	{
#ifdef Q_WS_MAEMO_5
		QMaemo5InformationBox::information(this, "Failed to add new tag: " + QString(m_hEvernote->getLastErrorString().c_str()), QMaemo5InformationBox::DefaultTimeout);
#else
		QMessageBox::critical(this, "Failed to add new tag", QString(m_hEvernote->getLastErrorString().c_str()));
#endif
	}
#ifdef Q_WS_MAEMO_5
	setAttribute(Qt::WA_Maemo5ShowProgressIndicator, false);
#endif

	delete pDlg;

}
