#ifndef QNOTESVIEW_H
#define QNOTESVIEW_H

#include <QtGui/QMainWindow>
#include "QvernoteWindow.h"
#include <QGraphicsWidget>
#include <QGraphicsGridLayout>
#include "ui_QNotesView.h"
#include "QvernoteAPI.h"
#include "QNoteWidget.h"
#include "QNotesViewGraphicsWidget.h"
#include "QNoteListItemWidget.h"
#include <QThread>
using namespace qvernote::api;

class QNotesView : public QvernoteWindow
{
    Q_OBJECT

public:

    QNotesView(QvernoteAPI* hEvernote, const Notebook& notebook, QWidget *parent = 0);
    QNotesView(QvernoteAPI* hEvernote, QString windowTitle, QWidget *parent = 0);
    ~QNotesView();

    QvernoteAPI* getHandle() { return m_hEvernote; }
    Notebook getNotebook() { return m_Notebook; }

    void getNextNote(Note& nextNote);
    void getPrevNote(Note& prevNote);
    void clearNote(Note& m_Note);

public slots:
	void reloadNotes();
	void loadNotesIntoView();
	void openNewNoteWindow();
	void openNoteEditor(QListWidgetItem *item);
	//void openNoteEditor(QNoteListItemWidget *item);
	void openNoteEditor(Note&, QEnmlReader* reader = 0);
	void openNoteViewer(QListWidgetItem *item);
	void loadDeleteNotesView();
	void notesViewShutdown();

	bool backgroundJobCallback() { return queryNotes(); }
    void jobDoneCallback() { loadNotesIntoView(); }
    void jobFailedCallback() { notesViewShutdown(); }

private:
	bool queryNotes();

private:
    Ui::QNotesViewClass ui;
    QvernoteAPI* m_hEvernote;
    vector<QNoteWidget*>	m_vNoteWidgets;
    Notebook	m_Notebook;
};

#endif // QNOTESVIEW_H
