#include "QNotesView.h"
#include "QNoteEditWindow.h"
#include <QPropertyAnimation>
#include <QDebug>
#include <QGraphicsPixmapItem>
#include <QGraphicsView>
#include <QPixmap>
#include <QMessageBox>
#include <QGraphicsProxyWidget>
#include <QGraphicsGridLayout>
#include "QNoteListItemWidget.h"
#include "QNoteEditWindow.h"
#include "QDeleteNotesView.h"
#include "QNoteViewWindow.h"

using namespace qvernote;
using namespace qvernote::api;

QNotesView::QNotesView(QvernoteAPI* hEvernote, const Notebook& notebook, QWidget *parent)
    : QvernoteWindow(parent), m_hEvernote(hEvernote), m_Notebook(notebook)
{
	ui.setupUi(this);

	this->setWindowTitle(QString(notebook.name.c_str()));
	ui.gridLayout_2->setAlignment(ui.lvNoteList, Qt::AlignTop);

	QObject::connect(ui.actionReload, SIGNAL(triggered(bool)), this, SLOT(reloadNotes()));
	QObject::connect(ui.pbNewNote, SIGNAL(clicked()), this, SLOT(openNewNoteWindow()));
	//QObject::connect(ui.lvNoteList, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(openNoteEditor(QListWidgetItem *)));
	QObject::connect(ui.lvNoteList, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(openNoteViewer(QListWidgetItem *)));

	QObject::connect(ui.actionDelete_notes, SIGNAL(triggered(bool)), this, SLOT(loadDeleteNotesView()));

	setProgressIndicator(true);
	m_pBackgroundJob->start();
	displayInformationBox("Loading notes. Please wait...");
}

QNotesView::QNotesView(QvernoteAPI* hEvernote, QString windowTitle, QWidget *parent)
: QvernoteWindow(parent), m_hEvernote(hEvernote)
{
	ui.setupUi(this);

	this->setWindowTitle(windowTitle);
	ui.pbNewNote->setVisible(false);

	ui.gridLayout_2->setAlignment(ui.lvNoteList, Qt::AlignTop);
	QObject::connect(ui.lvNoteList, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(openNoteEditor(QListWidgetItem *)));
	loadNotesIntoView();
}

QNotesView::~QNotesView()
{

}

void QNotesView::reloadNotes()
{
	m_pBackgroundJob->start();
}

void QNotesView::loadNotesIntoView()
{
	Note note;
	bool hasMoreNotes = true;
	//int maxColumns = (int)((int)this->geometry().width() / (int)225) - 1;
	//int columnCount = 0;
	//int rowIndex = 0;
	//int noteCount = 0;

	//qDebug() << "maxColumns" << maxColumns;
	ui.lvNoteList->clear();
	ui.lvNoteList->setVisible(false);
	ui.lvNoteList->setListItemHeight(70);

	for(hasMoreNotes = m_hEvernote->getFirstNote(note); hasMoreNotes; hasMoreNotes = m_hEvernote->getNextNote(note))
	{
		//QNoteWidget* w = new QNoteWidget(note, this);
		//w->setAttribute(Qt::WA_OpaquePaintEvent, true);
		//m_vNoteWidgets.push_back(w);
		//QGraphicsProxyWidget* gp = scene.addWidget(w);
		//gp->setGeometry(QRectF(columnCount*(w->width() + 20), rowIndex*(w->height() + 20), w->width(), w->height()));

		QListWidgetItem* iw = new QListWidgetItem(ui.lvNoteList);
		iw->setSizeHint(QSize(0, 70));
		ui.lvNoteList->setItemWidget(iw, new QNoteListItemWidget(note, false, this));

		/*if(columnCount >= maxColumns)
		{
			columnCount = 0;
			rowIndex++;
		}
		else
		{
			columnCount++;
		}*/

	}

	ui.lvNoteList->setVisible(true);
	setProgressIndicator(false);
}

void QNotesView::openNewNoteWindow()
{
	Note newNote;// = new Note();
	newNote.notebookGuid = m_Notebook.guid;
	QNoteEditWindow* pNoteEditWindow = new QNoteEditWindow(newNote, true, NULL, this);
	QObject::connect(pNoteEditWindow, SIGNAL(noteListUpdated()),this, SLOT(loadNotesIntoView()));
	pNoteEditWindow->show();
}

void QNotesView::openNoteEditor(QListWidgetItem *item)
{
	QNoteListItemWidget* w = (QNoteListItemWidget*)ui.lvNoteList->itemWidget(item);

	//QNoteEditWindow* pNoteEditWindow = new QNoteEditWindow(w->getNote(), w->getHtml(), m_hEvernote, this);
	//pNoteEditWindow->show();
	openNoteEditor(w->getNote());
}
/*
void QNotesView::openNoteEditor(QNoteListItemWidget *item)
{
	//QNoteEditWindow* pNoteEditWindow = new QNoteEditWindow(item->getNote(), false, m_hEvernote, 0, this);
	//pNoteEditWindow->show();
	openNoteEditor(item->getNote());
}
*/
void QNotesView::openNoteEditor(Note& note, QEnmlReader* reader)
{
	QNoteEditWindow* pNoteEditWindow = new QNoteEditWindow(note, false, reader, this);
	pNoteEditWindow->show();
}

void QNotesView::openNoteViewer(QListWidgetItem *item)
{
	QNoteListItemWidget* w = (QNoteListItemWidget*)ui.lvNoteList->itemWidget(item);
	QNoteViewWindow* pWnd = new QNoteViewWindow(w->getNote(), this);
	connect(pWnd, SIGNAL(startEditorSignal(Note&, QEnmlReader*)), this, SLOT(openNoteEditor(Note&, QEnmlReader*)));
	pWnd->show();
}

void QNotesView::getNextNote(Note& nextNote)
{
	QList<QListWidgetItem*> l = ui.lvNoteList->selectedItems();
	QListWidgetItem* nextItem = ui.lvNoteList->item(ui.lvNoteList->row(l[0]) + 1);

	if(nextItem == NULL)
	{
		displayInformationBox("This is the last note");
	}
	else
	{
		QNoteListItemWidget* w = (QNoteListItemWidget*)ui.lvNoteList->itemWidget(nextItem);
		ui.lvNoteList->setItemSelected(nextItem, true);
		nextNote = w->getNote();
	}
}

void QNotesView::getPrevNote(Note& prevNote)
{
	QList<QListWidgetItem*> l = ui.lvNoteList->selectedItems();

	if(ui.lvNoteList->row(l[0]) == 0)
	{
		displayInformationBox("This is the first note");
	}
	else
	{
		QListWidgetItem* prevItem = ui.lvNoteList->item(ui.lvNoteList->row(l[0]) - 1);
		ui.lvNoteList->setItemSelected(prevItem, true);
		QNoteListItemWidget* w = (QNoteListItemWidget*)ui.lvNoteList->itemWidget(prevItem);
		prevNote = w->getNote();
	}
}

void QNotesView::loadDeleteNotesView()
{
	QDeleteNotesView* p_Wnd = new QDeleteNotesView(m_hEvernote, QString(m_Notebook.name.c_str()), this);
	p_Wnd->show();
}

void QNotesView::notesViewShutdown()
{
	displayError("Error loading notebook", QString(m_hEvernote->getLastErrorString().c_str()));
	close();
}

bool QNotesView::queryNotes()
{
	return m_hEvernote->loadNotes(100000, m_Notebook);
}

void QNotesView::clearNote(Note& m_Note)
{
	qDebug() << "Delete note content";

	m_Note.content.clear();
	m_Note.content.reserve(0);
	m_Note.tagNames.clear();
	m_Note.tagGuids.clear();
	for(vector<Resource>::iterator i = m_Note.resources.begin(); i != m_Note.resources.end(); i++)
	{
		(*i).data.body.clear();
		(*i).data.body.reserve(0);
		(*i).recognition.body.clear();
		(*i).alternateData.body.clear();
	}
}
