#ifndef QNOTEVIEWWINDOW_H
#define QNOTEVIEWWINDOW_H

#include <QtGui/QMainWindow>
#include "ui_QNoteViewWindow.h"
#include "QvernoteWindow.h"
#include "QvernoteAPI.h"
#include "QEnmlReader.h"

using namespace qvernote::api;

class QNoteViewWindow : public QvernoteWindow
{
    Q_OBJECT

public:
    QNoteViewWindow(const Note& note, QWidget *parent = 0);
    ~QNoteViewWindow();

    void hideEvent ( QHideEvent * );
    void showEvent ( QShowEvent * );

public slots:
    void startEditor();
    void resizeWebView();
    void loadResource(QUrl);
    void zoominView();
    void zoomoutView();
    void emailNote();
    void loadNextNote();
    void loadPrevNote();

    bool loadNote();
    void displayNote();
    void backgroundLoad();
    bool backgroundJobCallback() { return loadNote(); }
    void jobDoneCallback() { displayNote(); }
    void jobFailedCallback() { displayError("Unable to load note", QString(m_hEvernote->getLastErrorString().c_str())); }

signals:
    void startEditorSignal(Note&, QEnmlReader*);

private:
	void clearNote();

private:
    Ui::QNoteViewWindowClass ui;
    Note m_Note;
    QvernoteAPI* m_hEvernote;
    shared_ptr<QEnmlReader> enmlReader;
};

#endif // QNOTEVIEWWINDOW_H
