#include "QNoteViewWindow.h"
#include <QWebFrame>
#include "QEmailNoteDialog.h"
#include "QNotesView.h"
#include "QNoteEditWindow.h"

#ifdef Q_WS_MAEMO_5
#include <QAbstractKineticScroller>
#include "QMaemoTextSelectionSupressor.h"
#endif

QNoteViewWindow::QNoteViewWindow(const Note& note, QWidget *parent)
    : QvernoteWindow(parent), m_Note(note)
{
	ui.setupUi(this);

	QObject::connect(ui.wvNoteView, SIGNAL(loadFinished(bool)), this, SLOT(resizeWebView()));
	m_hEvernote = dynamic_cast<QNotesView*>(this->parentWidget())->getHandle();
	enmlReader = shared_ptr<QEnmlReader>(new QEnmlReader(m_hEvernote));

	//loadNote();
	ui.wvNoteView->page()->setLinkDelegationPolicy(QWebPage::DelegateAllLinks);

#ifdef Q_WS_MAEMO_5
	QMaemoTextSelectionSupressor* supressor = new QMaemoTextSelectionSupressor(ui.wvNoteView);
	supressor->enable();
	//ui.wvNoteEdit->property("kineticScroller").value<QAbstractKineticScroller *>()->setEnabled(true);
#endif

	QToolBar* noteControlToolbar = new QToolBar();
	QAction* actEditNote = new QAction(QIcon(":/IconAdd/general_sketch.png"), "Edit note", this);
	QAction* actEmailNote = new QAction(QIcon(":/IconAdd/general_email.png"), "Email note", this);
	QAction* actZoomin = new QAction(QIcon(":/IconAdd/note_zoomin.png"), "Zoom In", this);
	QAction* actZoomout = new QAction(QIcon(":/IconAdd/note_zoomout.png"), "Zoom Out", this);

	QAction* actNext = new QAction(QIcon(":/IconAdd/general_forward.png"), "Next note", this);
	QAction* actPrev = new QAction(QIcon(":/IconAdd/general_back.png"), "Previous note", this);

	noteControlToolbar->addAction(actEditNote);
	noteControlToolbar->addAction(actEmailNote);
	noteControlToolbar->addAction(actZoomin);
	noteControlToolbar->addAction(actZoomout);

	noteControlToolbar->addAction(actPrev);
	noteControlToolbar->addAction(actNext);

	this->addToolBar(noteControlToolbar);

	QObject::connect(actEditNote, SIGNAL(triggered()), SLOT(startEditor()));
	QObject::connect(actEmailNote, SIGNAL(triggered()), SLOT(emailNote()));
	QObject::connect(actZoomin, SIGNAL(triggered()), this, SLOT(zoominView()));
	QObject::connect(actZoomout, SIGNAL(triggered()), this, SLOT(zoomoutView()));
	QObject::connect(actNext, SIGNAL(triggered()), SLOT(loadNextNote()));
	QObject::connect(actPrev, SIGNAL(triggered()), SLOT(loadPrevNote()));

	QObject::connect(ui.wvNoteView, SIGNAL(linkClicked(QUrl)), this, SLOT(loadResource(QUrl)));

	//setProgressIndicator(true);
	//m_pBackgroundJob->start();
}

QNoteViewWindow::~QNoteViewWindow()
{

}

void QNoteViewWindow::hideEvent ( QHideEvent * )
{
	//dynamic_cast<QNotesView*>(this->parentWidget())->clearNote(m_Note);
}

void QNoteViewWindow::showEvent ( QShowEvent * )
{
	//qDebug() << __FUNCTION__ << "Loading note";
	backgroundLoad();
}

bool QNoteViewWindow::loadNote()
{
	//qDebug() << "Loading note";
	if(m_hEvernote->getNote(m_Note) == false)
	{
		displayError("Unable to load note", QString(m_hEvernote->getLastErrorString().c_str()));
		setProgressIndicator(false);
		return false;
	}

	return true;
}

void QNoteViewWindow::displayNote()
{
	Notebook notebook;

	enmlReader->parse(m_Note);
	ui.wvNoteView->setHtml(enmlReader->getHtml());
	ui.lNoteTitle->setText(QString::fromUtf8(m_Note.title.c_str()));

	if(m_hEvernote->getNotebookByGuid(notebook, m_Note.notebookGuid))
		ui.lNotebookName->setText(QString("In: ") + QString::fromStdString(notebook.name));
	else
		ui.lNotebookName->setText("Unknown notebook");

	/* load tag names */
	vector<string>::iterator it;
	QString tagList = 0;
	for(it = m_Note.tagNames.begin(); it < m_Note.tagNames.end(); it++)
	{
		tagList += QString((*it).c_str()) + " ";
	}

	if(tagList.size() == 0)
		ui.lNoteTags->setText("No tags");
	else
		ui.lNoteTags->setText(tagList);

	setProgressIndicator(false);
}

void QNoteViewWindow::startEditor()
{
	//emit startEditorSignal(m_Note, enmlReader.get());
	//close();
	QNoteEditWindow* pNoteEditWindow = new QNoteEditWindow(m_Note, false, enmlReader.get(), this);
	QObject::connect(pNoteEditWindow, SIGNAL(noteUpdated()), this, SLOT(backgroundLoad()));
	pNoteEditWindow->show();
}

void QNoteViewWindow::resizeWebView()
{
	QSize s = ui.wvNoteView->page()->mainFrame()->contentsSize();
	const QRect fr = ui.wvNoteView->frameGeometry();
	const QRect cr = ui.wvNoteView->contentsRect();

	//qDebug() << "contentSize" << s;
	//qDebug() << "frameGeometry" << fr;
	//qDebug() << "contentRect" << cr;
	//s.setHeight(s.height() + 1 * ui.wvNoteEdit->fontMetrics().lineSpacing());
	ui.wvNoteView->setMinimumHeight(qMax(70, s.height()  + (fr.height() - cr.height() - 1)));
	ui.scrollArea->ensureVisible(0, 0);
}

void QNoteViewWindow::loadResource(QUrl url)
{
	setProgressIndicator(true);
	//qDebug() << __FUNCTION__ << QByteArray::fromHex(url.toString().toAscii());
	Resource r;

	if(m_hEvernote->loadResourceByHash(r, m_Note.guid, QByteArray::fromHex(url.toString().toAscii()).data()) == true)
	{
		QString fileName = QFileDialog::getSaveFileName(
				this,
				tr("Save resource"),
		        "/MyDocs/" + QString::fromStdString(r.attributes.fileName),
		        tr("Images (*.png *.gif *.jpg);;Audio (*.wav *.mpg *.amr *.mp3);;Documents (*.pdf);;Other (*)"));

		if(fileName.size() > 0)
		{
			QFile file(fileName);
			if (!file.open(QIODevice::WriteOnly))
			{
				displayError("Cannot write file", file.errorString());
				return;
			}

			QDataStream out(&file);
			out.writeRawData(r.data.body.c_str(), r.data.size);
			file.close();
			qDebug() << "Resource saved";
		}
	}
	else
	{
		displayError("Failed to load resource", QString::fromStdString(m_hEvernote->getLastErrorString()));
	}
	setProgressIndicator(false);
}

void QNoteViewWindow::zoominView()
{
	ui.wvNoteView->setZoomFactor(ui.wvNoteView->zoomFactor()+0.1);
}

void QNoteViewWindow::zoomoutView()
{
	ui.wvNoteView->setZoomFactor(ui.wvNoteView->zoomFactor()-0.1);
}

void QNoteViewWindow::emailNote()
{
	QEmailNoteDialog* pDlg;

	pDlg = new QEmailNoteDialog(m_Note, m_hEvernote, this);
	pDlg->exec();
	delete pDlg;
}

void QNoteViewWindow::loadNextNote()
{
	dynamic_cast<QNotesView*>(this->parentWidget())->clearNote(m_Note);
	((QNotesView*)this->parentWidget())->getNextNote(m_Note);
	backgroundLoad();
}

void QNoteViewWindow::loadPrevNote()
{
	dynamic_cast<QNotesView*>(this->parentWidget())->clearNote(m_Note);
	((QNotesView*)this->parentWidget())->getPrevNote(m_Note);
	backgroundLoad();
}

void QNoteViewWindow::backgroundLoad()
{
	setProgressIndicator(true);
	m_pBackgroundJob->start();
}
