#ifndef QNOTEEDITWINDOW_H
#define QNOTEEDITWINDOW_H

#include <QtGui/QMainWindow>
#include "QvernoteWindow.h"
#include "ui_QNoteEditWindow.h"
#include "QvernoteAPI.h"
#include "QEnmlWriter.h"
#include "QEnmlReader.h"
#include <QWebElement>
using namespace qvernote::api;

class QNoteEditWindow : public QvernoteWindow
{
    Q_OBJECT

public:
    QNoteEditWindow(Note& note, bool bIsNewNote, QEnmlReader *reader = 0, QWidget *parent = 0);
    ~QNoteEditWindow();

    void hideEvent ( QHideEvent * );

signals:
    void noteListUpdated();
    void noteUpdated();

public slots:
    void saveNote();
    void emailNote();
    void toggleBoldStyle();
    void toggleItalicStyle();
    void toggleUnderlineStyle();
    void addBullet();
    void attachFile();
    void resizeWebView();
    void openTagSelectorDialog();
    void setTag(bool, Tag);
    void loadResource(QUrl);
    void insertTodo();

    void zoominView();
    void zoomoutView();

    bool backgroundJobCallback() { return createNote(); }
    void jobDoneCallback() { setProgressIndicator(false); emit noteListUpdated(); close(); }
    void jobFailedCallback() { noteSaveFailure(); }

    /* JS API slots */
    void setChecked(int tagId);

private:
    bool createNote();
    void noteSaveFailure();

private:
    Ui::QNoteEditWindowClass ui;
    Note m_Note;
    QString m_HtmlData;
    bool	isNewNote;
    QvernoteAPI* m_hEvernote;
    shared_ptr<QEnmlReader> enmlReader;
    shared_ptr<QEnmlWriter> enmlWriter;
    int nTodoTagCount;
};

#endif // QNOTEEDITWINDOW_H
