#include "QDeleteNotesView.h"
#include "QNoteListItemWidget.h"
#include "QNotesView.h"

QDeleteNotesView::QDeleteNotesView(QvernoteAPI* hEvernote, const QString& notebookName, QWidget *parent)
    : QvernoteWindow(parent), m_hEvernote(hEvernote), m_notebookName(notebookName), m_iSelectedCount(0), m_parent(parent)
{
	ui.setupUi(this);

	this->setWindowTitle(notebookName);
	m_pbDeleteSelected.setText("Delete");
	ui.gridLayout_2->setAlignment(ui.lwDeleteNoteList, Qt::AlignTop);

	//m_pbDeleteSelected.setIcon(QIcon(":/IconAdd/general_stop.png"));
	//m_lSelectedCount.setText("0 selected");
	//ui.statusBar->setLayoutDirection(Qt::RightToLeft);
	ui.statusBar->addWidget(&m_pbDeleteSelected);
	ui.statusBar->addWidget(&m_lSelectedCount);
	QObject::connect(&m_pbDeleteSelected, SIGNAL(clicked()), this, SLOT(deleteSelectedNotes()));
	QObject::connect(ui.lwDeleteNoteList, SIGNAL(itemClicked(QListWidgetItem *)), this, SLOT(setItemMark(QListWidgetItem *)));
	loadNotesIntoView();
}

QDeleteNotesView::~QDeleteNotesView()
{

}

void QDeleteNotesView::loadNotesIntoView()
{
	Note note;
	bool hasMoreNotes = true;
	QNoteListItemWidget* listItem;

	setProgressIndicator(true);

	ui.lwDeleteNoteList->setListItemHeight(70);

	for(hasMoreNotes = m_hEvernote->getFirstNote(note); hasMoreNotes; hasMoreNotes = m_hEvernote->getNextNote(note))
	{
		QListWidgetItem* iw = new QListWidgetItem(ui.lwDeleteNoteList);
		iw->setSizeHint(QSize(0, 70));
		listItem = new QNoteListItemWidget(note, true, this);
		connect(listItem, SIGNAL(noteMarked()), this, SLOT(addSelectedCount()));
		connect(listItem, SIGNAL(noteUnmarked()), this, SLOT(subSelectedCount()));
		ui.lwDeleteNoteList->setItemWidget(iw, listItem);
	}

	setProgressIndicator(false);
}

void QDeleteNotesView::setItemMark(QListWidgetItem *item)
{
	QNoteListItemWidget* w = (QNoteListItemWidget*)ui.lwDeleteNoteList->itemWidget(item);
	w->mark();
}

void QDeleteNotesView::deleteSelectedNotes()
{
	QNoteListItemWidget* currItem;
	QListWidgetItem* listWidgetItem;

	if(m_iSelectedCount == 0 ||
	       QMessageBox::question(this,
	    		   "Confirm",
	    		   QString("Ready to delete %1 notes?").arg(m_iSelectedCount),
	    		   QMessageBox::Ok|QMessageBox::Cancel,
	    		   QMessageBox::Ok) == QMessageBox::Cancel)
			return;

	setProgressIndicator(true);
	m_pbDeleteSelected.setEnabled(false);

	for(int i = 0; i < ui.lwDeleteNoteList->count(); i++)
	{
		listWidgetItem = ui.lwDeleteNoteList->item(i);
		currItem = (QNoteListItemWidget*)ui.lwDeleteNoteList->itemWidget(listWidgetItem);

		if(currItem->isItemMarked())
		{
			if(m_hEvernote->deleteNote(currItem->getNote()) == false)
			{
				displayError("Unable to delete note", QString(m_hEvernote->getLastErrorString().c_str()));
			}
			else
			{
				currItem->close();
				ui.lwDeleteNoteList->removeItemWidget(listWidgetItem);
				subSelectedCount();
			}
		}
	}

	setProgressIndicator(false);
	m_pbDeleteSelected.setEnabled(true);

	ui.lwDeleteNoteList->clear();
	loadNotesIntoView();

	((QNotesView*)m_parent)->loadNotesIntoView();
}
