#!/usr/bin/python
# -*- coding: utf-8 -*-
#QuizzyNator by Marian Klühspies

#Importe
import sys
import time
import random
import os
import fragenkatalog
import subprocess
import webbrowser
import urllib
import smtplib
from PyQt4.phonon import Phonon
from PyQt4 import QtCore
from PyQt4.QtCore import Qt, QString
from PyQt4 import QtGui
from PyQt4.QtGui import QPicture
from PyQt4.uic import loadUi


       
class MainWindow(QtGui.QMainWindow):
    def __init__(self):
        QtGui.QMainWindow.__init__(self)


#Überprüfen, ob das Spiel auf dem PC oder N900 ausgeführt wird.Wer seine autorun.inf gelöscht hat, hat pech^^
#Pfade N900:
        if os.path.isfile("/opt/quizzynator/main.py"):
            self.ui=loadUi("/opt/quizzynator/quiz.ui")
            self.ui.show()
            self.ui.showFullScreen()
            self.ui.setAttribute(Qt.WA_Maemo5PortraitOrientation, True)            
            try:
                os.makedirs("/home/user/MyDocs/.Quizzynator/")
            except:
                pass  
           
            self.richtigsound="/opt/quizzynator/richtig.wav"
            self.falschsound="/opt/quizzynator/falsch.wav"
            self.gameoversound="/opt/quizzynator/gameover.wav"
            self.rankupsound="/opt/quizzynator/rankup.wav"
           
            #self.fragenkatalog="/home/user/MyDocs//fragenkatalog.py"      
            self.highscoredatenbank="/home/user/MyDocs/.QuizzyNator/highscores.db"
#Pfade PC:
        else:
            self.ui=loadUi("quiz.ui")
            self.ui.show()
            self.richtigsound="richtig.wav"
            self.falschsound="falsch.wav"
            self.gameoversound="gameover.wav"
            self.rankupsound="rankup.wav"
            
            self.highscoredatenbank="highscores.db"
            self.versionspfad="version.ini"
#Phonon initiieren

        self.m_media = Phonon.MediaObject(self)
        audioOutput = Phonon.AudioOutput(Phonon.MusicCategory, self)
        Phonon.createPath(self.m_media, audioOutput)
        
#Grundeinstellungen zum Startup


        self.ui.stackedWidget.setCurrentIndex(0)
        self.ui.close.show()
        self.ui.minimize.show()
        self.ui.vollbild.setChecked(True)
        self.ui.hochformat.setChecked(True)
        self.soundaktiv=False        
#Startwerte setzen
        self.score=0
        self.niederlagencounter=0
        self.anzahlfragen=0
        self.richtigefragen=0
        self.rangcounter=0
#Buttons + Widgets Funktionszuordnung        
        self.ui.punktestand.setText("Punktestand: "+str(self.score)+" Falsche Antworten: "+str(self.niederlagencounter))
        self.ui.beenden.clicked.connect(self.closefunc)
        self.ui.close.clicked.connect(self.closefunc)
        self.ui.minimize.clicked.connect(self.minimizefunc)
        self.ui.neuesspiel.clicked.connect(self.neuesspiel)
        self.ui.beginnen.clicked.connect(self.spielstarten)
        self.ui.zurueck.clicked.connect(self.settings)
        self.ui.settings.clicked.connect(self.settings)
        self.ui.menuesettings.triggered.connect(self.settings)
        self.ui.back.clicked.connect(self.back)
        self.ui.back_2.clicked.connect(self.back_2)
        self.ui.back_3.clicked.connect(self.back_2)
        self.ui.back_4.clicked.connect(self.back_2)
        #self.ui.updater.clicked.connect(self.update)
        self.ui.search.clicked.connect(self.search)
        self.ui.sound.toggled.connect(self.sound)
        self.ui.start_update.clicked.connect(self.updating)
        self.ui.vollbild.toggled.connect(self.vollbild)
        self.ui.hochformat.toggled.connect(self.format)
        self.ui.nextquest.clicked.connect(self.choose_frage)
        self.ui.frageneinreichen.clicked.connect(self.fragen_einreichen)
        self.ui.newgame.clicked.connect(self.neuesspiel)
        self.ui.exitgame.clicked.connect(self.closefunc)
        self.ui.craveofrage.clicked.connect(self.send_email)
        self.ui.spielladen.clicked.connect(self.spielladen)
        self.ui.highscores.clicked.connect(self.highscores)
        self.ui.start_ng.clicked.connect(self.neuesspiel)
        self.ui.about.clicked.connect(self.aboutquiz)
        self.ui.linktohomepage.clicked.connect(self.craveobrowser)
        
        #Antworten
        
        self.ui.antwort_1.clicked.connect(self.antwort_1)
        self.ui.antwort_2.clicked.connect(self.antwort_2)
        self.ui.antwort_3.clicked.connect(self.antwort_3)
        self.ui.antwort_4.clicked.connect(self.antwort_4)
      
    def neuesspiel(self):
        self.ui.stackedWidget.setCurrentIndex(3)
        self.niederlagencounter=0
        self.punktestand=0
        self.rangcounter=0
        self.score=0
        
    def aboutquiz(self):
        self.ui.stackedWidget.setCurrentIndex(8)
        
    def back(self):
        self.ui.stackedWidget.setCurrentIndex(2)  
          
    def back_2(self):
#Dafür sorgen, dass die zuvor getätigten Bildeinstellungen beim Klick auf Zurück wieder übernommen werden
        self.ui.stackedWidget.setCurrentIndex(1)
        if self.ui.hochformat.isChecked():
            self.ui.setAttribute(Qt.WA_Maemo5PortraitOrientation, True)
        if self.ui.querformat.isChecked():
            self.ui.setAttribute(Qt.WA_Maemo5PortraitOrientation, False) 
            
    def spielstarten(self):
#Spiel mit voreingestelltem Schwierigkeitsgrad und Spielername initiieren
        self.limitindex=self.ui.schwierigkeit.currentIndex()
        if self.limitindex==0:
            self.limit=11
        elif self.limitindex==1:
            self.limit=6
        elif self.limitindex==2:
            self.limit=4
        elif self.limitindex==3:
            self.limit=100000    
        self.spielername=self.ui.playername.text()
        if self.spielername=="":
            self.spielername="Defaultplayer"  
            
        self.ui.stackedWidget.setCurrentIndex(2)
        self.choose_frage()
    
    def spielladen(self):
#Gespeichertes Spiel laden
        if os.path.isfile("quizzynator.db"):
            if os.lstat("quizzynator.db").st_size>0:
                self.load_user()
                self.ui.stackedWidget.setCurrentIndex(2)                 
            else:
                pass
        else:
            pass  
    
    def status_check(self):
#Überprüfen, ob der Spieler schon Gameover ist
        if self.niederlagencounter>=self.limit:
            self.ui.statistikanzeige.setText("Statistik:\n\n"
                                             "Punkte: "+str(self.score)+"\n"
                                             "Spielername: "+str(self.spielername)+"\n"
                                             "Schwierigkeit: "+self.ui.schwierigkeit.currentText()+"\n"
                                             "Beantwortete Fragen: "+str(self.anzahlfragen)+"\n"
                                             "Richtige Fragen: "+str(self.richtigefragen)+"\n"
                                             "Falsche Fragen: "+str(self.limit)+"\n"
                                             "Rang: "+str(self.rang))
            if self.soundaktiv==True:
                self.m_media.setCurrentSource(Phonon.MediaSource(self.gameoversound))
                self.m_media.play()
            self.ui.stackedWidget.setCurrentIndex(6)
#Falls ja, alle Werte in Highscore speichern, anschließend nullen
            self.save_highscore()
            self.niederlagencounter=0
            self.score=0
            self.anzahlfragen=0
            self.rangcounter=0
    
    
    def choose_frage(self):
#Rankingabfragen
        self.anzahlfragen+=1   
        self.ui.punktestand.setText("Punktestand: "+str(self.score)+" Falsche: "+str(self.niederlagencounter))
        if self.score==0:
            self.rang="Amateur"
            self.ui.rang.setText("Spieler: "+str(self.spielername)+"   Rang: "+str(self.rang))
        elif self.score==100:
            self.rang="Wannabe"
            self.rankup()
            self.ui.rang.setText("Spieler: "+str(self.spielername)+"   Rang: "+str(self.rang))
        elif self.score==350:
            self.rang="Wissenshungriger"
            self.rankup()
            self.ui.rang.setText("Spieler: "+str(self.spielername)+"   Rang: "+str(self.rang))
        elif self.score==750:
            self.rang="Lehrmeister"
            self.rankup()
            self.ui.rang.setText("Spieler: "+str(self.spielername)+"   Rang: "+str(self.rang))
        elif self.score==950:
            self.rang="Erhabener"
            self.rankup()
            self.ui.rang.setText("Spieler: "+str(self.spielername)+"   Rang: "+str(self.rang))
        elif self.score==1200:
            self.rang="Fast-Allwissender"
            self.rankup()
            self.ui.rang.setText("Spieler: "+str(self.spielername)+"   Rang: "+str(self.rang))
        elif self.score==1500:
            self.rang="Dalai Lama"
            self.rankup()
            self.ui.rang.setText("Spieler: "+str(self.spielername)+"   Rang: "+str(self.rang))     
                               
        self.ui.antwort_1.show()
        self.ui.antwort_2.show()
        self.ui.antwort_3.show()
        self.ui.antwort_4.show()
        self.ui.nextquest.hide()
#Auslesen von fragenkatalog.py + Randomfragen + Shuffle Buttoninhalte
        question = random.choice(fragenkatalog.questions)
        self.ui.textfrage.setText(question.question)
        self.antwort1=question.answer
        self.antwort2=question.answer2
        self.antwort3=question.answer3
        self.antwort4=question.answer4
        self.antwort1=unicode(self.antwort1, "utf-8")
        self.antwort2=unicode(self.antwort2, "utf-8")
        self.antwort3=unicode(self.antwort3, "utf-8")
        self.antwort4=unicode(self.antwort4, "utf-8")
        l=[self.antwort1,self.antwort2,self.antwort3,self.antwort4]
        random.shuffle(l)
        self.ui.antwort_1.setText(l[0])
        self.ui.antwort_2.setText(l[1])
        self.ui.antwort_3.setText(l[2])
        self.ui.antwort_4.setText(l[3])
        self.richtigeantwort=unicode(self.antwort1)
       
#Buttonabfrage: Stimmt der Inhalt des Buttons mit dem Inhalt "Richtige Antwort" überein?
    def antwort_1(self):
        antwort=self.ui.antwort_1.text()
        antwort=antwort.toLatin1()

        if self.richtigeantwort==antwort:
            self.ui.textfrage.append("\nIhre Antwort ist richtig")
            self.score+=10
            self.richtigefragen+=1
            self.ui.punktestand.setText("Punktestand: "+str(self.score)+" Falsche Antworten: "+str(self.niederlagencounter))
            self.ui.nextquest.show()
            self.ui.antwort_1.hide()
            self.ui.antwort_2.hide()
            self.ui.antwort_3.hide()
            self.ui.antwort_4.hide()
            self.soundrichtig()
        else:
            self.ui.textfrage.append("\nIhre Antwort ist falsch.\nDie richtige Anwort ist: "+self.richtigeantwort)
            self.score-=10
            self.niederlagencounter+=1
            self.ui.punktestand.setText("Punktestand: "+str(self.score)+" Falsche Antworten: "+str(self.niederlagencounter))
            self.ui.antwort_1.hide()
            self.ui.antwort_2.hide()
            self.ui.antwort_3.hide()
            self.ui.antwort_4.hide()            
            self.ui.nextquest.show()
            self.soundfalsch()   
                
        self.status_check()
                 
             
    def antwort_2(self):
        antwort=self.ui.antwort_2.text()
        antwort=antwort.toLatin1()

        if self.richtigeantwort==antwort:
            self.ui.textfrage.append("\nIhre Antwort ist richtig")
            self.ui.nextquest.show()
            self.richtigefragen+=1
            self.score+=10
            self.ui.antwort_1.hide()
            self.ui.antwort_2.hide()
            self.ui.antwort_3.hide()
            self.ui.antwort_4.hide()            
            self.ui.punktestand.setText("Punktestand: "+str(self.score)+" Falsche Antworten: "+str(self.niederlagencounter))
            self.soundrichtig()
        else:
            self.ui.textfrage.append("\nIhre Antwort ist falsch.\nDie richtige Anwort ist: "+self.richtigeantwort)
            self.ui.nextquest.show()
            self.niederlagencounter+=1
            self.score-=10
            self.ui.punktestand.setText("Punktestand: "+str(self.score)+" Falsche Antworten: "+str(self.niederlagencounter))
            self.ui.antwort_1.hide()
            self.ui.antwort_2.hide()
            self.ui.antwort_3.hide()
            self.ui.antwort_4.hide() 
            self.soundfalsch() 
        self.status_check()                     
                   
    def antwort_3(self):
        antwort=self.ui.antwort_3.text()
        antwort=antwort.toLatin1()

        if self.richtigeantwort==antwort:
            self.ui.textfrage.append("\nIhre Antwort ist richtig")
            self.ui.nextquest.show()
            self.ui.antwort_1.hide()
            self.ui.antwort_2.hide()
            self.ui.antwort_3.hide()
            self.ui.antwort_4.hide()
            self.richtigefragen+=1
            self.score+=10
            self.ui.punktestand.setText("Punktestand: "+str(self.score)+" Falsche Antworten: "+str(self.niederlagencounter))
            self.soundrichtig()
            
        else:
            self.ui.textfrage.append("\n Ihre Antwort ist falsch.\nDie richtige Anwort ist: "+self.richtigeantwort)    
            self.ui.nextquest.show()
            self.niederlagencounter+=1
            self.score-=10
            self.ui.punktestand.setText("Punktestand: "+str(self.score)+" Falsche Antworten: "+str(self.niederlagencounter))
            self.ui.antwort_1.hide()
            self.ui.antwort_2.hide()
            self.ui.antwort_3.hide()
            self.ui.antwort_4.hide() 
            self.soundfalsch()      
        self.status_check()                                          
    def antwort_4(self):
        antwort=self.ui.antwort_4.text()
        antwort=antwort.toLatin1()
   
        if self.richtigeantwort==antwort:
            self.ui.textfrage.append("\nIhre Antwort ist richtig")
            self.ui.nextquest.show()
            self.ui.antwort_1.hide()
            self.ui.antwort_2.hide()
            self.ui.antwort_3.hide()
            self.ui.antwort_4.hide()
            self.richtigefragen+=1
            self.score+=10
            self.ui.punktestand.setText("Punktestand: "+str(self.score)+" Falsche Antworten: "+str(self.niederlagencounter))
            self.soundrichtig()
        else:
            self.ui.textfrage.append("\nIhre Antwort ist falsch.\nDie richtige Anwort ist: "+self.richtigeantwort)     
            self.ui.nextquest.show()
            self.niederlagencounter+=1
            self.score-=10
            self.ui.punktestand.setText("Punktestand: "+str(self.score)+" Falsche Antworten: "+str(self.niederlagencounter))
            self.ui.antwort_1.hide()
            self.ui.antwort_2.hide()
            self.ui.antwort_3.hide()
            self.ui.antwort_4.hide()         
            self.soundfalsch()
                     
        self.status_check()
    def settings(self):
        self.ui.stackedWidget.setCurrentIndex(1)  
        
    def load_user(self):
        userdata={}
        fobj=open("quizzynator.db","r")
        for line in fobj:
            zuordnung=line.split()
            userdata[zuordnung[0]]=zuordnung[1]
        fobj.close    
        self.spielername=userdata["Spielername"]
        self.niederlagencounter=userdata["Niederlagen"]
        self.score=userdata["Score"]        
        self.niederlagencounter=int(self.niederlagencounter)
        self.score=int(self.score)
        self.ui.playername.setText(self.spielername)
        self.ui.punktestand.setText("Punktestand: "+str(self.score)+" Falsche Antworten: "+str(self.niederlagencounter))
        self.ui.antwort_1.hide()
        self.ui.antwort_2.hide()
        self.ui.antwort_3.hide()
        self.ui.antwort_4.hide()
        self.ui.textfrage.setText(u"Spielstand erfolgreich geladen.Sie können nun fortfahren.")
                            
        
    def save_settings(self):
#Funktionsname outdated.Hier wird der Spielstand gespeichert.Derzeit klappt das nur, wenn man die Applikation im Fullscreenmode laufen lässt und auf Beenden klickt
#Ein klick auf X zeigt keine wirkung
        playername=self.ui.playername.text()
     
        default=open("quizzynator.db","w")
               
        userdata={"Spielername":str(playername),
                  "Score":str(self.score),
                  "Niederlagen":str(self.niederlagencounter)}
                
        for data in userdata:
            default.write(data+" " + userdata[data]+"\n")
        default.close()
                 
     
    def save_highscore(self):    
#Highscore speichern
        if os.path.isfile(self.highscoredatenbank):
            if os.lstat(self.highscoredatenbank).st_size>0:
                fobj=open(self.highscoredatenbank,"r")
                self.scores=fobj.read()
                fobj.close()
            else:
                self.scores=""
        else:
            self.scores=""      
#Inhalte der Highscoreliste  
        self.scores=self.scores+"\nName: "+str(self.spielername)+" Punkte: "+str(self.score)+" "+self.ui.schwierigkeit.currentText()+"\n"
        fobj=open(self.highscoredatenbank,"w")
        fobj.write(self.scores)
        fobj.close()        
                
           
       
    def highscores(self):
#Highscore anzeigen
        highscores=[]
        if os.path.isfile(self.highscoredatenbank):
            if os.lstat(self.highscoredatenbank).st_size>0:
                fobj=open(self.highscoredatenbank,"r")
                self.scores=fobj.read()
                fobj.close()
                self.ui.highscoreanzeige.setText(self.scores)   
        self.ui.stackedWidget.setCurrentIndex(7)        
            
           
       
       
    def minimizefunc(self):#Experimentell, schließt statt zu minimieren
        subprocess.Popen(['dbus-send', '--type=signal', '--session', '/com/nokia/hildon_desktop', 'com.nokia.hildon_desktop.exit_app_view'])        
            
    def closefunc(self):#Methode zum Schließen des Mainwindows
        self.save_settings()
        sys.exit()
        
    def sound(self):
        status=self.ui.sound.checkState()
        if status==0:
            self.soundaktiv=False
        if status==2:
            self.soundaktiv=True
            
#Soundfunktionen, die aktiviert werden, sobald man dies in den Einstellungen festsetzt(boolean)   
    def rankup(self):
        if self.soundaktiv==True:
            self.m_media.setCurrentSource(Phonon.MediaSource(self.rankupsound)) 
            self.m_media.play()
    
    def soundrichtig(self):
        if self.soundaktiv==True:
            self.m_media.setCurrentSource(Phonon.MediaSource(self.richtigsound))
            self.m_media.play()
    
    def soundfalsch(self):
        if self.soundaktiv==True:    
            self.m_media.setCurrentSource(Phonon.MediaSource(self.falschsound))
            self.m_media.play()
        
    def vollbild(self):    
#Vollbild an/aus
        bildstatus=self.ui.vollbild.checkState()
        if bildstatus==0:
            self.ui.showNormal()
            self.ui.minimize.hide()
            self.ui.close.hide()
            self.ui.settings.hide()
        if bildstatus==2:
            self.ui.showFullScreen()
            self.ui.minimize.show()
            self.ui.close.show()
            self.ui.settings.show()
            
            
    def format(self):
#Bildformat ändern
        if self.ui.hochformat.isChecked():
            self.ui.setAttribute(Qt.WA_Maemo5PortraitOrientation, True)
        if self.ui.querformat.isChecked():
            self.ui.setAttribute(Qt.WA_Maemo5PortraitOrientation, False) 
             
        
    def craveobrowser(self):
        webbrowser.open("http://www.craveo.de")
#Möglichkeit, eigene Fragen einzureichen       
    def fragen_einreichen(self):
        self.ui.stackedWidget.setCurrentIndex(5)
        self.ui.einreichenstatus.hide()
        self.ui.emailquestion.show()
        self.ui.emailright.show()
        self.ui.emailwrong1.show()
        self.ui.emailwrong2.show()
        self.ui.emailwrong3.show()
        self.ui.label_9.show()
        self.ui.label_10.show()
        self.ui.label_11.show()
        self.ui.label_12.show()
        self.ui.label_13.show()
        self.ui.setAttribute(Qt.WA_Maemo5PortraitOrientation, False)
        
    def send_email(self):       
        self.emailfrage=self.ui.emailquestion.text()
        self.emailfrage=self.emailfrage.toLatin1()   
        self.emailright=self.ui.emailright.text()
        self.emailright=self.emailright.toLatin1()
        self.emailwrong1=self.ui.emailwrong1.text()
        self.emailwrong1=self.emailwrong1.toLatin1()
        self.emailwrong2=self.ui.emailwrong2.text()
        self.emailwrong2=self.emailwrong2.toLatin1()
        self.emailwrong3=self.ui.emailwrong3.text()
        self.emailwrong3=self.emailwrong3.toLatin1()  
        self.ui.emailquestion.hide()
        self.ui.emailright.hide()
        self.ui.emailwrong1.hide()
        self.ui.emailwrong2.hide()
        self.ui.emailwrong3.hide()
        self.ui.label_9.hide()
        self.ui.label_10.hide()
        self.ui.label_11.hide()
        self.ui.label_12.hide()
        self.ui.label_13.hide()
        emailtext="Question(u'"+str(self.emailfrage)+"','"+str(self.emailright)+"','"+str(self.emailwrong1)+"','"+str(self.emailwrong2)+"','"+str(self.emailwrong3)+"')"
       
        try:
            smtp=smtplib.SMTP("alfa3053.alfahosting-server.de")
            smtp.login("web1197p3", "n900quiz")
            smtp.sendmail("n900quizuser@craveo.de", ["mariankluehspies@gmx.de"], emailtext)
            self.ui.einreichenstatus.show()
            self.ui.einreichenstatus.setText(u"Frage erfolgreich übertragen!")
            self.ui.emailquestion.clear()
            self.ui.emailright.clear()
            self.ui.emailwrong1.clear()
            self.ui.emailwrong2.clear()
            self.ui.emailwrong3.clear()
        except:
            self.ui.einreichenstatus.show()
            self.ui.einreichenstatus.setText(u"Fehler bei der Übermittlung.Internetverbindung prüfen!")    
    
app = QtGui.QApplication(sys.argv)
main = MainWindow()
sys.exit(app.exec_())           