import QtQuick 1.1

ListView {
    property string playerPath: "/opt/kmplayer/bin/kmplayer" // /opt/qmvideoplayer/qmvideoplayer
    id: listView
    model: ListModel {}
    delegate: VButton {
        text: vsize + "MB"
        fontsize: 17
        source: "image://imageprovider/"+vpath
        onClicked: {
            mainW._playFlash(vpath, playerPath)
            mainW.hide()
            main0.viewLoader.source = "file:/" + appPath + "/qml/SideMenu.qml"
        }
    }

    Button {
        anchors.bottom: parent.bottom
        fontsize: 17
        text: "return"
        onClicked: {
            main0.viewLoader.source = "file:/" + appPath + "/qml/SideMenu.qml"
        }
    }

    Connections {
        target: mainW
        onShowVideos: {
            listView.model.clear() // ?
        }
        onVideoFound: {
            listView.model.append(item)
        }
        onEdgeSignal: {
            if(window == "browser")
            {
                mainW._show()
            }
        }
    }
}
