#include "mainwindow.h"
#include "Process.h"
#include "imageprovider.h"

MainWindow* MainWindow::mw = NULL;

MainWindow::MainWindow(QWidget *parent) :
    QDeclarativeView(parent)
{
    if(QApplication::desktop()->height() > QApplication::desktop()->width()) {
        isPortrait = true;
        move(0, 160);
    }
    else {
        isPortrait = false;
        move(0, 0);
    }

    QDBusConnection::sessionBus().connect("","",
                                          "com.qtedger.signal",
                                          "edge", this, SLOT(onEdgeSignal(QStringList)));

    setFocusPolicy(Qt::NoFocus);

    setAttribute(Qt::WA_OpaquePaintEvent);
    setAttribute(Qt::WA_NoSystemBackground);
    viewport()->setAttribute(Qt::WA_OpaquePaintEvent);
    viewport()->setAttribute(Qt::WA_NoSystemBackground);
    setOptimizationFlags(QGraphicsView::DontSavePainterState);
    setViewportUpdateMode(QGraphicsView::FullViewportUpdate);

    Process *proc = new Process(this);
    rootContext()->setContextProperty("Process", proc);
    rootContext()->setContextProperty("mainW", this);
    rootContext()->setContextProperty("appPath", QCoreApplication::applicationDirPath());

    engine()->addImageProvider("imageprovider", new ImageProvider);

    setResizeMode(QDeclarativeView::SizeViewToRootObject);
    setAutoFillBackground(true);

    setSource(QUrl::fromLocalFile(QString::fromLatin1("/%1/%2").arg(
                                      QCoreApplication::applicationDirPath(), "qml/main.qml")));

    connect(QApplication::desktop(), SIGNAL(resized(int)), this, SLOT(onOrientationChanged()));

    setWindowFlags(Qt::WindowStaysOnTopHint |
                   Qt::FramelessWindowHint |
                   Qt::X11BypassWindowManagerHint);

    XWindowAttributes xwa;
    XGetWindowAttributes(QX11Info::display(), this->winId(), &xwa);
    XSelectInput(QX11Info::display(), this->winId(), xwa.your_event_mask | VisibilityChangeMask);
    installEventFilter(this);

    mw = this;
    QCoreApplication::instance()->setEventFilter(myEventFilter);

#ifndef Q_WS_MAEMO_5
    show();
#endif
}

MainWindow::~MainWindow()
{
    mw->deleteLater();
}

void MainWindow::_back()
{
    Display *dpy = QX11Info::display();
    int key_backspace = 22;
    XTestFakeKeyEvent(dpy, key_backspace, true, 0);
    XTestFakeKeyEvent(dpy, key_backspace, false, 0);
    XFlush(dpy);
}

void MainWindow::_reload()
{
    Display *dpy = QX11Info::display();
    int key_ctrl = 37;
    KeyCode key_l = XKeysymToKeycode(dpy, 'r');
    XTestFakeKeyEvent(dpy, key_ctrl, true, 0);
    XTestFakeKeyEvent(dpy, key_l, true, 0);
    XTestFakeKeyEvent(dpy, key_ctrl, false, 0);
    XTestFakeKeyEvent(dpy, key_l, false, 0);
    XFlush(dpy);
}

void MainWindow::_addressBar()
{
    Display *dpy = QX11Info::display();
    int key_ctrl = 37;
    KeyCode key_l = XKeysymToKeycode(dpy, 'l');
    XTestFakeKeyEvent(dpy, key_ctrl, true, 0);
    XTestFakeKeyEvent(dpy, key_l, true, 0);
    XTestFakeKeyEvent(dpy, key_ctrl, false, 0);
    XTestFakeKeyEvent(dpy, key_l, false, 0);
    XFlush(dpy);
}

void MainWindow::_closeWindow()
{
    QDBusMessage msg = QDBusMessage::createMethodCall("com.nokia.osso_browser",
                       "/com/nokia/osso_browser/request",
                       "com.nokia.osso_browser", //sic
                       "close_window");
    QDBusConnection::sessionBus().asyncCall(msg);
}

void MainWindow::_bookmarks()
{
    Display *dpy = QX11Info::display();
    int key_ctrl = 37;
    KeyCode key_l = XKeysymToKeycode(dpy, 'b');
    XTestFakeKeyEvent(dpy, key_ctrl, true, 0);
    XTestFakeKeyEvent(dpy, key_l, true, 0);
    XTestFakeKeyEvent(dpy, key_ctrl, false, 0);
    XTestFakeKeyEvent(dpy, key_l, false, 0);
    XFlush(dpy);
}

void MainWindow::_showTaskMenu()
{
    QDBusMessage _taskMenu = QDBusMessage::createSignal("/com/nokia/hildon_desktop",
                             "com.nokia.hildon_desktop",
                             "set_state");
    _taskMenu << 64;
    QDBusConnection::sessionBus().send(_taskMenu);
}

void MainWindow::_previousWindow()
{
    QProcess proc(this);
    proc.startDetached("matchbox-remote", QStringList() << "-prev");
}

void MainWindow::_show()
{
    showFullScreen(); //show() doesn't work good in non-fullscreen mode in microb
}

void MainWindow::onOrientationChanged()
{
    if(QApplication::desktop()->height()>QApplication::desktop()->width())
    {
        isPortrait = true;
        move(0, 160);
    }
    else
    {
        isPortrait = false;
        move(0, 0);
    }
}

void MainWindow::_findFlash()
{
    QProcess *proc = new QProcess(this);
    proc->start("sh", QStringList() << "-c" << "lsof -c browserd +d /proc | grep Flash"); //tested on flash 9

    proc->waitForFinished();
    proc->waitForReadyRead();

    QString outline;

    QStringList outputList;

    do {
         outline = proc->readLine();
         if(!outline.isEmpty())
            outputList.append(outline);

    } while(!outline.isEmpty());

    emit showVideos();

    for(int i = 0; i < outputList.count(); ++i)
    {
        QString output = outputList.at(i).simplified();

        QString vid = output.split(" ").at(3);
        vid = vid.remove(QRegExp("[a-zA-Z]"));

        QString arg = QString("/proc/%1/fd/%2").arg(output.split(" ").at(1), vid);

        float fsize = output.split(" ").at(6).toInt();
        fsize /= 1024*1024;
        fsize = (float)((int)(fsize*100))/100;

        QVariantMap vitem;
        vitem.insert("vsize", QString::number(fsize));
        vitem.insert("vpath", arg);
        emit videoFound(vitem);
    }
    proc->waitForFinished();
    proc->deleteLater();
}

void MainWindow::_playFlash(QString vpath, QString playerPath)
{
     QProcess *proc = new QProcess();
     connect(proc, SIGNAL(finished(int)), proc, SLOT(deleteLater()));
     proc->startDetached(playerPath, QStringList() << vpath);
}

void MainWindow::_showEvent()
{
    emit menuShowEvent();
}

bool MainWindow::myEventFilter(void *message, long int *)
{
    XEvent *e = reinterpret_cast<XEvent *>(message);

    if(e->type == VisibilityNotify)
    {
        if(e->xvisibility.state == VisibilityUnobscured)
        {
            MainWindow *m = (MainWindow*)MainWindow::instance();
            emit m->menuShowEvent();
        }
    }
    return false;
}

const MainWindow* MainWindow::instance()
{
    return mw;
}

