#    Copyright 2009, Brent Chiodo.

#    Quick Clip is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

import ConfigParser
import os

HOME = os.getenv('HOME')

class Settings:

   def load(self):
      try:
         user_config_file = open(HOME + '/.quickclip/quickclip.conf', 'r')
         user_config_access = ConfigParser.RawConfigParser()
         user_config_access.readfp(user_config_file)
   
         settings_dict = {}
         settings_dict['path'] = user_config_access.get('DEFAULT', 'path')
         settings_dict['view_program'] = user_config_access.get('DEFAULT', 'view_program')
         settings_dict['edit_program'] = user_config_access.get('DEFAULT', 'edit_program')
         settings_dict['default_menu_positioning'] = int(user_config_access.get('DEFAULT', 'default_menu_positioning'))
         settings_dict['use_date_stamp'] = self.helper_function(user_config_access.get('DEFAULT', 'use_date_stamp'))
         settings_dict['use_separater'] = self.helper_function(user_config_access.get('DEFAULT', 'use_separater'))
   
         user_config_file.close()
      except ConfigParser.NoOptionError:
         # Settings file doesn't have the required option,
         # most likely because of an old preference file

         self.write_defaults(None)
         settings_dict = self.load()

      return settings_dict

   def helper_function(self, arg):
      if arg == 'True':
         return True
      elif arg == 'False':
         return False

   def write(self, path, view_program, edit_program, use_date_stamp, use_separater, default_menu_positioning):
      user_config_file = open(HOME + '/.quickclip/quickclip.conf', 'w')
      user_config_access = ConfigParser.RawConfigParser()

      user_config_access.set('DEFAULT', 'path', path)
      user_config_access.set('DEFAULT', 'view_program', view_program)
      user_config_access.set('DEFAULT', 'edit_program', edit_program)
      user_config_access.set('DEFAULT', 'use_date_stamp', use_date_stamp)
      user_config_access.set('DEFAULT', 'use_separater', use_separater)
      user_config_access.set('DEFAULT', 'default_menu_positioning', default_menu_positioning)

      user_config_access.write(user_config_file)
      user_config_file.close()

   def write_defaults(self, widget, data=None):
      user_config_file = open(HOME + '/.quickclip/quickclip.conf', 'w')
      user_config_access = ConfigParser.RawConfigParser()

      user_config_access.set('DEFAULT', 'path', '/home/user/MyDocs/Quick_Clip/')
      user_config_access.set('DEFAULT', 'view_program', '$builtin')
      user_config_access.set('DEFAULT', 'edit_program', '/usr/bin/dbus-send --print-reply --dest=com.nokia.osso_notes /com/nokia/osso_notes com.nokia.osso_notes.mime_open string:"%s"')
      user_config_access.set('DEFAULT', 'use_date_stamp', True)
      user_config_access.set('DEFAULT', 'use_separater', True)
      user_config_access.set('DEFAULT', 'default_menu_positioning', 0)

      user_config_access.write(user_config_file)
      user_config_file.close()