#    Copyright 2009, Brent Chiodo.

#    Quick Clip is free software: you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation, either version 3 of the License, or
#    (at your option) any later version.

#    This program is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.

#    You should have received a copy of the GNU General Public License
#    along with this program.  If not, see <http://www.gnu.org/licenses/>.

from settings import *
import xml.etree.ElementTree as ET
import os
import subprocess

HOME = os.getenv('HOME')

class Target_Files:
   def __init__(self):
      self.settings = Settings().load()

   def create_files(self):
      files = self.get_files()
      for item in files:
         if not os.path.exists(self.settings['path'] + item + '.txt'):
            command = 'touch "%s%s%s"' % (self.settings['path'], item, '.txt')
            subprocess.Popen(command, shell=True)

   def indent(self, elem, level=0):
      i = "\n" + level*"  "
      if len(elem):
         if not elem.text or not elem.text.strip():
            elem.text = i + "  "
         if not elem.tail or not elem.tail.strip():
            elem.tail = i
         for elem in elem:
            self.indent(elem, level+1)
         if not elem.tail or not elem.tail.strip():
            elem.tail = i
      else:
         if level and (not elem.tail or not elem.tail.strip()):
            elem.tail = i

   def set_files(self, files):
      root = ET.Element("config")
      for item in files:
         file = ET.SubElement(root, "file")
         file.text = item
      self.indent(root)
      tree = ET.ElementTree(root)
      tree.write(HOME + '/.quickclip/parent_files.xml')
      self.create_files()

   def get_files(self):
      tree = ET.parse(HOME + '/.quickclip/parent_files.xml')
      elements = tree.getroot()
      files_list = []
      for subelement in elements:
         files_list.append(subelement.text)
      return files_list