# This file is part of Quick Clip

from target_files import *
import gtk

class Main_Menu:
   def __init__(self):
      self.files = Target_Files().get_files()
      
   def create_parent_func(self):

      for item in self.files:
         menu_group = gtk.MenuItem(item)
         self.menu.append(menu_group)

         self.submenu = gtk.Menu()
         menu_selection = gtk.MenuItem("Selection >> File")
         menu_entry = gtk.MenuItem("Entry >> File")
         menu_view = gtk.MenuItem("View")
         menu_edit = gtk.MenuItem("Edit")
         menu_clear = gtk.MenuItem("Clear")
         menu_delete = gtk.MenuItem("Delete")
         self.submenu.append(menu_selection)
         self.submenu.append(menu_entry)
         self.submenu.append(gtk.SeparatorMenuItem())
         self.submenu.append(menu_view)
         self.submenu.append(menu_edit)
         self.submenu.append(gtk.SeparatorMenuItem())
         self.submenu.append(menu_clear)
         self.submenu.append(menu_delete)
         menu_selection.connect('activate', Clip_Tools().clip_selection, item)
         menu_entry.connect('activate', Dialogs().entry_dialog, item)
         menu_view.connect('activate', Clip_Tools().view_file, item)
         menu_edit.connect('activate', Clip_Tools().edit_file, item)
         menu_clear.connect('activate', Clip_Tools().clear_file, item)
         menu_delete.connect('activate', Clip_Tools().delete_file, item)
         menu_group.set_submenu(self.submenu)
         
   def default_menu_positioning_func(self):

      menu_group = gtk.MenuItem("Options")
      self.menu.append(menu_group)

      self.submenu = gtk.Menu()
      about_item = gtk.MenuItem("About Quick Clip")
      manage_item = gtk.MenuItem("Manage Files...")
      settings_item = gtk.MenuItem("Settings...")
      donations_item = gtk.MenuItem("Donations")
      help_item = gtk.MenuItem("Help")
      self.submenu.append(about_item)
      self.submenu.append(manage_item)
      self.submenu.append(settings_item)
      self.submenu.append(donations_item)
      self.submenu.append(help_item)
      about_item.connect('activate',Dialogs().about_dialog)
      manage_item.connect('activate',Manage_Files().manage_files)
      settings_item.connect('activate',Settings_Dialog().settings)
      donations_item.connect('activate',Dialogs().donations)
      help_item.connect('activate',Dialogs().help)
      menu_group.set_submenu(self.submenu)

      self.history_menu()

# History menu

   def history_menu(self):

      menu_group = gtk.MenuItem("History")
      self.menu.append(menu_group)

      self.submenu = gtk.Menu()

      if len(self.history) == 0:
         history_label = gtk.MenuItem("(No History)")
         history_label.set_sensitive(False)
         history_label.modify_fg(gtk.STATE_INSENSITIVE, None)
         self.submenu.append(history_label)
      else:
         clear_label = gtk.MenuItem("Clear History")
         clear_label.connect('activate', History.clear)
         self.submenu.append(clear_label)
         self.submenu.append(gtk.SeparatorMenuItem())

      for item in self.history:
         name = item
         target_index = self.history.index(item)
         self.set_history_menu(name, target_index, self.submenu)

      menu_group.set_submenu(self.submenu)