#include <hildon/hildon.h>
#include <gconf/gconf-client.h>

#include "quick-launch.h"



static gboolean
run_cmd()
{
	HildonDialog *c;
	GtkWidget *entry,*runte,*box;
	
	entry = hildon_entry_new (HILDON_SIZE_AUTO);
	runte = hildon_check_button_new ( HILDON_SIZE_AUTO );
	gtk_button_set_label (GTK_BUTTON (runte), "Run in terminal");
        hildon_gtk_entry_set_placeholder_text (GTK_ENTRY (entry), " Program name");
        box = gtk_vbox_new ( 0, FALSE );
        gtk_box_pack_start ( GTK_BOX(box), entry, FALSE,FALSE, 0 );
        gtk_box_pack_start ( GTK_BOX(box), runte, FALSE,FALSE, 0 );
	c = HILDON_DIALOG (hildon_dialog_new ());
	hildon_dialog_add_button (HILDON_DIALOG (c), GTK_STOCK_OK, GTK_RESPONSE_OK);
	gtk_window_set_title (GTK_WINDOW (c), "QuickLaunch: run command...");
	
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(c)->vbox), box);
	gtk_widget_show_all (GTK_WIDGET (c));
	
	int response;
	response = gtk_dialog_run (GTK_DIALOG (c));
	if ( response == GTK_RESPONSE_OK ) { //execute program
		if ( gtk_entry_get_text ( GTK_ENTRY(entry) ) == NULL ) {
			hildon_banner_show_information(NULL,NULL, "You must fill the text entry before");
		} else {
			gchar *bin;
			if ( hildon_check_button_get_active ( HILDON_CHECK_BUTTON (runte) ) ) { //run in terminal 
				bin = g_strdup_printf("/usr/bin/osso-xterm -e \"%s\"",gtk_entry_get_text ( GTK_ENTRY(entry) ));
			} else bin = gtk_entry_get_text ( GTK_ENTRY(entry) );

			gint argc;
			gchar **argv;
			pid_t pid;
			GError *error;
		
			if (g_shell_parse_argv(bin,&argc,&argv,NULL)) {
				if ( g_spawn_async(NULL,argv,NULL,(GSpawnFlags)G_SPAWN_SEARCH_PATH,NULL,NULL,&pid,&error) ) {
					g_spawn_close_pid (pid);
				}
			}
			
			if (error)
			{
				hildon_banner_show_information(NULL, NULL, g_strdup_printf("Execution failed : %s",error->message));
				g_error_free(error);
			}
			gtk_widget_destroy ( GTK_WIDGET(c) );
			if ( GTK_IS_WIDGET(d) ) gtk_widget_destroy( GTK_WIDGET(d) );			
		}
	}
	
	gtk_widget_destroy ( GTK_WIDGET(c));
	
	return FALSE;
}


int main ( int argc, char *argv[] )
{
	GtkWidget *bbox;
	GtkWidget *rbox;
	GtkWidget *abox;
	GtkWidget *rc;
	GConfClient* client;
	gint response;
	
	hildon_gtk_init (&argc, &argv);
	d = HILDON_DIALOG (hildon_dialog_new ());
	gtk_window_set_title (GTK_WINDOW (d), "QuickLaunch");
	bbox = gtk_hbox_new ( FALSE, 0 );
	rbox = gtk_hbox_new ( TRUE, 0 );
	abox = gtk_hbox_new ( FALSE, 0 );
	rc = hildon_button_new_with_text(HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL, "Run command...", "");
	int i;
   	for(i=0;i<4;i++) {
	   	btns[i] = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
	   	gtk_widget_set_size_request ( GTK_WIDGET(btns[i]), 64,64 );
		gtk_widget_show(btns[i]);
		gtk_box_pack_start(GTK_BOX(bbox), btns[i], FALSE, FALSE, 1);
		g_signal_connect ( G_OBJECT(btns[i]), "clicked", G_CALLBACK(load_app), (gpointer) i);
	}
	g_signal_connect ( G_OBJECT(rc), "clicked", G_CALLBACK(run_cmd), NULL );
	gtk_box_pack_start ( GTK_BOX(rbox), rc, FALSE,FALSE, 0 );
	gtk_box_pack_start ( GTK_BOX(abox), bbox, FALSE,FALSE,0 );
	gtk_box_pack_start ( GTK_BOX(abox), rbox, TRUE,TRUE,0 );
	

	client = gconf_client_get_default();
	
	gconf_client_add_dir(client,
                       g_strdup_printf("%s%s",GCONF_DIR,APP_NAME),
                       GCONF_CLIENT_PRELOAD_NONE,
                       NULL);

	g_print("gconf on %s%s\n",GCONF_DIR,APP_NAME);	
	parse_info(client);
	
	gtk_container_add (GTK_CONTAINER (GTK_DIALOG(d)->vbox), abox);
	gtk_widget_show_all (GTK_WIDGET (d));

       	gtk_dialog_run (GTK_DIALOG (d));
       	
       	gtk_widget_destroy ( GTK_WIDGET(d) );
	/*
	if ( response == GTK_RESPONSE_CANCEL ) {
		g_print("cancel reset started\n");
		started = FALSE;
	}

	g_print("started was =%d\n",started);
	started = FALSE;
	g_print("started is =%d\n",started);
		*/
	
	
	return 0;
}
