/*
	quick-launch status-bar applet
	
	@author	Daniele Maio (b0unc3) 
	@date	16/02/2010
	@ver	1.0
	
*/

#include <stdio.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include <libosso.h>
#include <gconf/gconf-client.h>

#include "quick-launch.h"

                         
#define QUICK_LAUNCH_STATUS_MENU_ITEM_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE (obj, QUICK_LAUNCH_TYPE_STATUS_MENU_ITEM, QuickLaunchStatusMenuItemPrivate))





struct _QuickLaunchStatusMenuItemPrivate
{
	gpointer data;
};

HD_DEFINE_PLUGIN_MODULE (QuickLaunchStatusMenuItem, quick_launch_status_menu_item, HD_TYPE_STATUS_MENU_ITEM)


static void
parse_info (GConfClient* client)
{
	GError *err;
	GtkWidget *icoim;
	int i;
	GSList *lst = NULL;
	gpointer *in;
	
	for(i=0;i<4;i++) {
		if (gconf_entry_get_value (g_strdup_printf("%s%s",APP_GCONF_KEY,group_name[i])) != NULL) {
			lst = gconf_client_get_list (GCONF_CLIENT(client),g_strdup_printf("%s%s",APP_GCONF_KEY,group_name[i]), GCONF_VALUE_STRING, &err);
			if ( lst != NULL ) {
				in = g_slist_nth_data (lst, 1);
				icoim = gtk_image_new_from_file( (gchar *)in );
				hildon_button_set_image ( HILDON_BUTTON(btns[i]), icoim );
				hildon_button_set_alignment (HILDON_BUTTON(btns[i]), 0.0, 0.0, 0.0, 0.0);
			}
		}
	}
	
}


static gboolean
load_app(GtkWidget *widget , gpointer data)
{
	gint pos;
	GKeyFile *conf;
	GError *err;
	gchar *oss,*cbin;
	oss = cbin = "";
	gpointer *o,*b;
	GSList *lst = NULL;
	GConfClient* client;
	
	/*init GConf */
	client = gconf_client_get_default();

	pos = (gint) data;
	if (gconf_entry_get_value (g_strdup_printf("%s%s",APP_GCONF_KEY,group_name[pos])) != NULL) {
		lst = gconf_client_get_list (GCONF_CLIENT(client),g_strdup_printf("%s%s",APP_GCONF_KEY,group_name[pos]), GCONF_VALUE_STRING, &err);
		if ( lst != NULL ) {
			o =  g_slist_nth_data (lst, 2);
			b =  g_slist_nth_data (lst, 3);
			oss = (gchar *)o;
			cbin = (gchar *)b;
			
			if ( g_strcasecmp(oss,"")!=0 ) {
				gboolean result;
			
				osso_context_t *osso=osso_initialize("quick-launch","0.1",TRUE,NULL);
				if ( !(result = osso_rpc_run_with_defaults(osso, oss, "top_application", NULL, DBUS_TYPE_INVALID) == OSSO_OK))
				{
					hildon_banner_show_information(NULL, NULL, "Execution failed");
				}
				osso_deinitialize(osso);
				return FALSE;
			
		
			} else if ( g_strcasecmp(cbin,"")!=0 ) { 
				gint argc;
				gchar **argv;
				pid_t pid;
				GError *error;
			
				if (g_shell_parse_argv(cbin,&argc,&argv,NULL)) {
					if ( g_spawn_async(NULL,argv,NULL,(GSpawnFlags)G_SPAWN_SEARCH_PATH,NULL,NULL,&pid,&error) ) {
						g_spawn_close_pid (pid);
						return FALSE;
					} else return FALSE;
				} else return FALSE;
				
				if (error)
				{
					hildon_banner_show_information(NULL, NULL, "Execution failed");
					g_error_free(error);
					return FALSE;
				}
			}
		}
	}
	
	return FALSE;
	/*
	if ( g_file_test(CONF_FILE, G_FILE_TEST_IS_REGULAR) ) {

		
		conf = g_key_file_new();
		if ( g_key_file_load_from_file ( conf, CONF_FILE, G_KEY_FILE_KEEP_COMMENTS, &err ) ) {
			if ( g_key_file_has_key ( conf, group_name[pos], "osso", &err ) ) { 
				oss = g_key_file_get_value ( conf, group_name[pos], "osso", &err );
			} 
			if ( g_key_file_has_key ( conf, group_name[pos], "bin", &err ) ) {
				cbin = g_key_file_get_value ( conf, group_name[pos], "bin", &err ); 
			}
		}
		g_key_file_free (conf);
		
		if ( g_strcasecmp(oss,"")!=0 ) {
			gboolean result;
			
			osso_context_t *osso=osso_initialize("quick-launch","0.1",TRUE,NULL);
			if ( !(result = osso_rpc_run_with_defaults(osso, oss, "top_application", NULL, DBUS_TYPE_INVALID) == OSSO_OK))
			{
				hildon_banner_show_information(NULL, NULL, "Execution failed");
			}
			osso_deinitialize(osso);
			return FALSE;
			
		
		} else if ( g_strcasecmp(cbin,"")!=0 ) { 
			gint argc;
			gchar **argv;
			pid_t pid;
			GError *error;
			
			if (g_shell_parse_argv(cbin,&argc,&argv,NULL)) {
				if ( g_spawn_async(NULL,argv,NULL,(GSpawnFlags)G_SPAWN_SEARCH_PATH,NULL,NULL,&pid,&error) ) {
					g_spawn_close_pid (pid);
					return FALSE;
				} else return FALSE;
			} else return FALSE;
				
			if (error)
			{
				hildon_banner_show_information(NULL, NULL, "Execution failed");
				g_error_free(error);
				return FALSE;
			}
		}
	}

	return FALSE;*/
}

static void
quick_launch_status_menu_item_class_finalize (QuickLaunchStatusMenuItemClass *klass) {}

static void
quick_launch_status_menu_item_class_init (QuickLaunchStatusMenuItemClass *klass)
{
    g_type_class_add_private (klass, sizeof (QuickLaunchStatusMenuItemPrivate));
}

static void
quick_launch_status_menu_item_init (QuickLaunchStatusMenuItem *plugin)
{
	GtkWidget *hbox,*icon;
	GConfClient* client;
	
	/*init GConf */
	client = gconf_client_get_default();

    	plugin->priv = QUICK_LAUNCH_STATUS_MENU_ITEM_GET_PRIVATE (plugin);
   	
   	hbox = gtk_hbox_new(FALSE, 0);
   	int i;
   	for(i=0;i<4;i++) {
	   	btns[i] = hildon_button_new(HILDON_SIZE_FINGER_HEIGHT, HILDON_BUTTON_ARRANGEMENT_VERTICAL);
		gtk_widget_show(btns[i]);
		icon = gtk_image_new_from_icon_name ( "qgn_list_cp_isetup", GTK_ICON_SIZE_BUTTON );
		gtk_widget_show(icon);
		gtk_button_set_image(GTK_BUTTON(btns[i]), GTK_WIDGET(icon));
		gtk_box_pack_start(GTK_BOX(hbox), btns[i], TRUE, TRUE, 1);
		g_signal_connect ( G_OBJECT(btns[i]), "clicked", G_CALLBACK(load_app), (gpointer) i);
	}
	// Pack widgets to menu
	gtk_widget_show(hbox);
	gtk_container_add(GTK_CONTAINER(plugin), hbox);
	gtk_widget_show(GTK_WIDGET(plugin));

	gconf_client_add_dir(client,
                       g_strdup_printf("%s%s",GCONF_DIR,APP_NAME),
                       GCONF_CLIENT_PRELOAD_NONE,
                       NULL);

  	gconf_client_notify_add(client, g_strdup_printf("%sfirst",APP_GCONF_KEY),
                          parse_info,
                          NULL,
                          NULL, NULL);
                          
	gconf_client_notify_add(client, g_strdup_printf("%ssecond",APP_GCONF_KEY),
                          parse_info,
                          NULL,
                          NULL, NULL);
                          
	gconf_client_notify_add(client, g_strdup_printf("%sthird",APP_GCONF_KEY),
                          parse_info,
                          NULL,
                          NULL, NULL);
                          
	gconf_client_notify_add(client, g_strdup_printf("%sfourth",APP_GCONF_KEY),
                          parse_info,
                          NULL,
                          NULL, NULL);

	parse_info(client);

}


