/*
 * This file is a part of Queen Beecon Widget
 * queen-beecon-progress-animation: Utility for QBW progress animation management
 *
 * http://talk.maemo.org/showthread.php?t=45388
 *
 * Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version. or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <glib.h>
#include <glib/gprintf.h>
#include <gtk/gtk.h>
#include "queen-beecon-logger.h"
#include "queen-beecon.h"
#include "queen-beecon-progress-animation.h"

gchar *qbwProgressAnimationAction[] = {
	"QBW_PROGRESS_ANIMATION_INIT",
	"QBW_PROGRESS_ANIMATION_START",
	"QBW_PROGRESS_ANIMATION_STOP",
	"QBW_PROGRESS_ANIMATION_FRAME",
	"QBW_PROGRESS_ANIMATION_DEINIT",
	NULL
};

static gboolean queen_beecon_exec_animation_callback(QueenBeecon *self)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) %s", self, G_STRFUNC);
	queen_beecon_exec_progress_animation(self, QBW_PROGRESS_ANIMATION_FRAME);
    return( TRUE );
}

void queen_beecon_exec_progress_animation(QueenBeecon *self, QbwProgressAnimationAction action)
{
	qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) %s action=%s OnSight=%d animationInProgress=%d", self, G_STRFUNC, qbwProgressAnimationAction[action], self->priv->qbwOnSight, self->priv->animationInProgress);
	guint i,pAP;
	gchar *progressImgFilename;
	GdkPixbuf *pixbuf;
	gint fx,fy,fw,fh;

	switch (action) {
	case QBW_PROGRESS_ANIMATION_INIT:
		progressImgFilename = g_strdup_printf("%squeen-beecon-progress0.png", SYSTEM_PUBLIC_ICON_DIR);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) Loading frame pixbuf %s", self, progressImgFilename);
		self->priv->beeExecuting_pixbuf[0] = gdk_pixbuf_new_from_file(progressImgFilename, NULL);
		g_free(progressImgFilename);
		self->priv->beeExecuting_img = gtk_image_new_from_pixbuf(self->priv->beeExecuting_pixbuf[0]);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Progress Image %p size[%dx%d]", self, self->priv->beeExecuting_img, (gint)self->priv->widWidth, (gint)self->priv->widHeight);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->beeExecuting_img), 1, 1);//(gint)self->priv->widWidth, (gint)self->priv->widHeight);

		self->priv->beeExecuting_fixed = gtk_fixed_new();
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->beeExecuting_img), gdk_pixbuf_get_width (self->priv->beeExecuting_pixbuf[0]), gdk_pixbuf_get_height (self->priv->beeExecuting_pixbuf[0]));
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->beeExecuting_fixed), gdk_pixbuf_get_width (self->priv->beeExecuting_pixbuf[0]), gdk_pixbuf_get_height (self->priv->beeExecuting_pixbuf[0]));
		gtk_table_attach(GTK_TABLE(self->priv->tableLayout), GTK_WIDGET(self->priv->beeExecuting_fixed), 0, 1, 0, 1, GTK_FILL|GTK_EXPAND, GTK_FILL|GTK_EXPAND, 0, 0);
		gtk_fixed_put (GTK_FIXED (self->priv->beeExecuting_fixed), self->priv->beeExecuting_img, 0, 0);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) beeExecuting_fixed=%p has_window=%d fixed x=%d y=%d img x=%d y=%d", self, self->priv->beeExecuting_fixed, gtk_fixed_get_has_window(GTK_FIXED (self->priv->beeExecuting_fixed)), self->priv->beeExecuting_fixed->allocation.x, self->priv->beeExecuting_fixed->allocation.y, self->priv->beeExecuting_img->allocation.x, self->priv->beeExecuting_img->allocation.y);
		break;

	case QBW_PROGRESS_ANIMATION_START:
		if (!self->priv->progressAnimationFrames) {self->priv->startupAnimation = FALSE;break;} // Is widget On Sight and frames needed? If no, nonsense to trigger animation
		if (!self->priv->startupAnimation) if (!self->priv->qbwOnSight) break; // Is widget On Sight and frames needed? If no, nonsense to trigger animation
		if (!self->priv->widgetVisible) break; // Is widget On Sight and frames needed? If no, nonsense to trigger animation
		if (self->priv->progressAnimationPos/9 == 1) {
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_lb));
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdTitle_img));
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_lb));
			gtk_widget_hide (GTK_WIDGET(self->priv->cmdResult_img));
		}
		self->priv->startupAnimation = FALSE;
		self->priv->animationInProgress = TRUE;
		self->priv->xx=self->priv->clickX;
		self->priv->yy=self->priv->clickY;
		for (i=0; i < self->priv->progressAnimationFrames; i++) {
			gchar *progressCustomImgFilename = NULL;
			gchar *progressCustomAux1ImgFilename = g_strdup_printf("%s%s%s%d.png", HOME_DIR, QUEEN_BEECON_MYDOCS_IMAGE_DIR, self->priv->progressAnimationBasename, i);
			gchar *progressCustomAux2ImgFilename = g_strdup_printf("%s%s%s%d.png", HOME_DIR, QUEEN_BEECON_PRIVATE_DIR, self->priv->progressAnimationBasename, i);
			gint w,h;
			GdkPixbufFormat *progressPixBufFmt = NULL;
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) progressAnimationFrame [%d/%d]", self, i, self->priv->progressAnimationFrames);
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Progress Image Aux1 [%s]", self, progressCustomAux1ImgFilename);
			progressPixBufFmt = gdk_pixbuf_get_file_info(progressCustomAux1ImgFilename,&w,&h);
			if (progressPixBufFmt!=NULL) {
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Progress Image Aux1 [%s] found", self, progressCustomAux1ImgFilename);
				progressCustomImgFilename = progressCustomAux1ImgFilename;
			} else {
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Progress Image Aux2 [%s]", self, progressCustomAux2ImgFilename);
				progressPixBufFmt = gdk_pixbuf_get_file_info(progressCustomAux2ImgFilename,&w,&h);
				if (progressPixBufFmt!=NULL) {
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Progress Image Aux2 [%s] found", self, progressCustomAux2ImgFilename);
					progressCustomImgFilename = progressCustomAux2ImgFilename;
				}
			}
			qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Custom Progress Image [%s] self->priv->beeExecuting_pixbuf[i]=%p", self, progressCustomImgFilename, self->priv->beeExecuting_pixbuf[i]);
			if (progressCustomImgFilename!=NULL) {
				GError *error = NULL;
				pixbuf = NULL;
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Custom Progress Image [%s] loading", self, progressCustomImgFilename);
				pixbuf = gdk_pixbuf_new_from_file(progressCustomImgFilename, &error);
				if (!pixbuf) {
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Custom Progress Image [%s] pixbuf ERROR [%s]", self, progressCustomImgFilename, error->message);
					g_free(error);
				} else {
					qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) Custom Progress Image [%s] pixbuf SUCCESS", self, progressCustomImgFilename);
					if (self->priv->beeExecuting_pixbuf[i] != NULL) {g_object_unref (self->priv->beeExecuting_pixbuf[i]);}
					self->priv->beeExecuting_pixbuf[i] = pixbuf;
				}
			} else {
				progressImgFilename = g_strdup_printf("%squeen-beecon-progress%d.png", SYSTEM_PUBLIC_ICON_DIR, i);
				qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) Loading frame pixbuf %s", self, progressImgFilename);
				self->priv->beeExecuting_pixbuf[i] = gdk_pixbuf_new_from_file(progressImgFilename, NULL);
				g_free(progressImgFilename);
			}
			g_free(progressCustomAux1ImgFilename);
			g_free(progressCustomAux2ImgFilename);
		}
		gtk_image_set_from_pixbuf (GTK_IMAGE(self->priv->beeExecuting_img), self->priv->beeExecuting_pixbuf[0]);

		pixbuf = self->priv->beeExecuting_pixbuf[0];
		fw=gdk_pixbuf_get_width (pixbuf);
		fh=gdk_pixbuf_get_width (pixbuf);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->beeExecuting_img), fw, fh);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->beeExecuting_fixed), fw, fh);
		pAP = self->priv->progressAnimationPos%9;
		fx=pAP%3==0?0:pAP%3==1?(gint)self->priv->widWidth/2-fw/2:(gint)self->priv->widWidth-fw;
		fy=pAP/3==0?0:pAP/3==1?(gint)self->priv->widHeight/2-fh/2:(gint)self->priv->widHeight-fh;
		if (self->priv->progressAnimationAtClickXY && self->priv->clickX!=-1 && self->priv->clickY!=-1 ) {
			fx=self->priv->xx-fw/2;
			fy=self->priv->yy-fh/2;
		}
		gtk_fixed_move(GTK_FIXED (self->priv->beeExecuting_fixed), self->priv->beeExecuting_img, fx, fy);

		gtk_widget_show(self->priv->beeExecuting_img);
		self->priv->beeExecuting_imgidx=1;
    	if (self->priv->timeout_id) {g_source_remove( self->priv->timeout_id );self->priv->timeout_id = 0;}
    	self->priv->timeout_id = g_timeout_add( self->priv->progressAnimationTimer*QBW_PROGRESS_ANIMATION_FRAMES_TIMER_STEPS_MSECS, (GSourceFunc)queen_beecon_exec_animation_callback, self);
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) progressAnimationFrames [%d] timeout_id=%d", self, self->priv->progressAnimationFrames, self->priv->timeout_id);
		break;

	case QBW_PROGRESS_ANIMATION_FRAME:
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) QBW_PROGRESS_ANIMATION_FRAME beeExecuting_imgidx=%d progressAnimationFrames=%d]", self, self->priv->beeExecuting_imgidx, self->priv->progressAnimationFrames);
		i = self->priv->beeExecuting_imgidx % self->priv->progressAnimationFrames;
		pixbuf = self->priv->beeExecuting_pixbuf[i];
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V4, "(%p) QBW_PROGRESS_ANIMATION progressAnimationFrame [%d/%d=%p]", self, i, self->priv->progressAnimationFrames, pixbuf);
		fw=gdk_pixbuf_get_width (pixbuf);
		fh=gdk_pixbuf_get_width (pixbuf);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->beeExecuting_img), fw, fh);
		gtk_widget_set_size_request(GTK_WIDGET(self->priv->beeExecuting_fixed), fw, fh);
		pAP = self->priv->progressAnimationPos%9;
		fx=pAP%3==0?0:pAP%3==1?(gint)self->priv->widWidth/2-fw/2:(gint)self->priv->widWidth-fw;
		fy=pAP/3==0?0:pAP/3==1?(gint)self->priv->widHeight/2-fh/2:(gint)self->priv->widHeight-fh;
		if (self->priv->progressAnimationAtClickXY && self->priv->clickX!=-1 && self->priv->clickY!=-1 ) {
			fx=self->priv->xx-fw/2;
			fy=self->priv->yy-fh/2;
		}
		gtk_fixed_move(GTK_FIXED (self->priv->beeExecuting_fixed), self->priv->beeExecuting_img, fx, fy);
		gtk_image_set_from_pixbuf (GTK_IMAGE(self->priv->beeExecuting_img), pixbuf);
		self->priv->beeExecuting_imgidx++;
		break;

	case QBW_PROGRESS_ANIMATION_STOP:
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) progressAnimationFrames [%d]", self, self->priv->progressAnimationFrames);
    	/* Remove timeout callback */
    	if (self->priv->timeout_id) {g_source_remove( self->priv->timeout_id );self->priv->timeout_id = 0;}
		if (self->priv->animationInProgress) {
			self->priv->animationInProgress = FALSE;
			gtk_widget_hide(self->priv->beeExecuting_img);
			if (self->priv->cmdVisibilityPosition    && self->priv->widgetVisible) if (self->priv->cmdTitle_lb) gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_lb));
			if (self->priv->cmdImgVisibilityPosition && self->priv->widgetVisible) if (self->priv->cmdTitle_img) gtk_widget_show (GTK_WIDGET(self->priv->cmdTitle_img));
			if (self->priv->resVisibilityPosition    && self->priv->widgetVisible) if (self->priv->cmdResult_lb) gtk_widget_show (GTK_WIDGET(self->priv->cmdResult_lb));
			if (self->priv->resImgVisibilityPosition && self->priv->widgetVisible) if (self->priv->cmdResult_img) gtk_widget_show (GTK_WIDGET(self->priv->cmdResult_img));
		}
		break;

	case QBW_PROGRESS_ANIMATION_DEINIT:
		qbw_logger(QBW_LOGGER_LOG, QBW_LOGGER_V3, "(%p) progressAnimationFrames [%d]", self, self->priv->progressAnimationFrames);
		for (i=0; i < QBW_PROGRESS_ANIMATION_FRAMES_MAX; i++) if (self->priv->beeExecuting_pixbuf[i] != NULL) g_object_unref (self->priv->beeExecuting_pixbuf[i]);
		break;

	default:
		return;
	}
	return;
}
