/*

queen-beecon.h - Queen Beecon Widget
http://talk.maemo.org/showthread.php?t=

Copyright (c) 2010 No!No!No!Yes! (Alessandro Peralma)

From and idea/application by cpscotti (Clovis Peruchi Scotti)
(Desktop Command Execution Widget http://talk.maemo.org/showthread.php?t=39177)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

[No!No!No!Yes!]

*/

#ifndef _QUEEN_BEECON
#define _QUEEN_BEECON

#include <dbus/dbus-glib.h>
#include <dbus/dbus-glib-bindings.h>
#include <libhildondesktop/libhildondesktop.h>
#include <time.h> /* For tm. */

G_BEGIN_DECLS

#define QUEEN_BEECON_TYPE queen_beecon_get_type()

#define QUEEN_BEECON(obj) \
(G_TYPE_CHECK_INSTANCE_CAST ((obj), QUEEN_BEECON_TYPE, QueenBeecon))

#define QUEEN_BEECON_CLASS(klass) \
(G_TYPE_CHECK_CLASS_CAST ((klass), QUEEN_BEECON_TYPE, QueenBeeconClass))

#define QUEEN_BEECON_IS(obj) \
(G_TYPE_CHECK_INSTANCE_TYPE ((obj), QUEEN_BEECON_TYPE))

#define QUEEN_BEECON_IS_CLASS(klass) \
(G_TYPE_CHECK_CLASS_TYPE ((klass), QUEEN_BEECON_TYPE))

#define QUEEN_BEECON_GET_CLASS(obj) \
(G_TYPE_INSTANCE_GET_CLASS ((obj), QUEEN_BEECON_TYPE, QueenBeeconClass))

typedef struct _QueenBeecon        QueenBeecon;
typedef struct _QueenBeeconClass   QueenBeeconClass;
typedef struct _QueenBeeconPrivate QueenBeeconPrivate;

struct _QueenBeecon
{
  HDHomePluginItem parent;

	QueenBeeconPrivate *priv;
};

struct _QueenBeeconClass
{
  HDHomePluginItemClass  parent;
  DBusGConnection *dbus_conn;
  DBusGProxy	*bus_proxy;
  gboolean 		dbus_registered;
  //GMutex 		*config_file_mutex;

  gboolean 		housekeeping;
  gboolean 		settingsOn;

  // Signal functions Declarations
  void (*queen_beecon_dbus_sig_content_updated) (QueenBeecon *self, gint exitCode);
};

GType queen_beecon_get_type (void);

// Methods Callback functions Declarations
static gboolean queen_beecon_dbus_cb_dbus_method_monitor (QueenBeecon *self, const gchar *newStatus, GError **error);
static gboolean queen_beecon_dbus_cb_reset_rearm_timer (QueenBeecon *self, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_show (QueenBeecon *self, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_hide (QueenBeecon *self, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_wakeup (QueenBeecon *self, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_sleep (QueenBeecon *self, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_update_content (QueenBeecon *self, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_update_layout (QueenBeecon *self, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_exec (QueenBeecon *self, const gchar *cmd, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_set_param_string (QueenBeecon *self, const gchar *param, const gchar *value, const gchar *update, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_set_param_int32 (QueenBeecon *self, const gchar *param, const gint value, const gchar *update, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_set_param_uint32 (QueenBeecon *self, const gchar *param, const guint value, const gchar *update, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_set_param_double (QueenBeecon *self, const gchar *param, const gdouble value, const gchar *update, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_set_param_boolean (QueenBeecon *self, const gchar *param, const gboolean value, const gchar *update, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_get_param (QueenBeecon *self, const gchar *param, gchar **value, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_is_on_sight (QueenBeecon *self, gchar **value, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_get_current_results_text (QueenBeecon *self, gchar **value, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_set_position (QueenBeecon *self, const gint widXOrigin, const gint widYOrigin, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_get_position (QueenBeecon *self, gint *widXOrigin, gint *widYOrigin, GError **error);
static gboolean queen_beecon_dbus_cb_dbus_get_exit_status (QueenBeecon *self, gint *exitStatus, GError **error);

G_END_DECLS

#endif /* _QUEEN_BEECON */
