#ifndef SCRIPTUREMODEL_H
#define SCRIPTUREMODEL_H

#include <QObject>
#include <QStringList>
#include <QNetworkAccessManager>
#include <QNetworkReply>

class ScriptureModel : public QObject
{
	Q_OBJECT
	Q_PROPERTY(QString url READ url WRITE setUrl NOTIFY urlChanged)
	Q_PROPERTY(QString verses READ verses NOTIFY versesChanged)
	Q_PROPERTY(QString listenUrl READ listenUrl NOTIFY listenUrlChanged)
public:
	explicit ScriptureModel(QObject *parent = 0);
	QString url() { return m_url; }
	QString verses() { return m_verses; }
	QString listenUrl() { return m_listenUrl; }
signals:
	void urlChanged(QString newUrl);
	void versesChanged(QString newVerses);
	void listenUrlChanged(QString newUrl);

public slots:
	void setUrl(QString value);
	void finished(QNetworkReply*);

private:

	QString m_url;
	QString m_verses;
	QString m_listenUrl;
	QNetworkAccessManager * nm;
};

#endif // SCRIPTUREMODEL_H
