#include "scripturemodel.h"
#include <QNetworkRequest>
#include <QNetworkAccessManager>
#include <QNetworkReply>
#include <QXmlQuery>
#include <QDebug>

ScriptureModel::ScriptureModel(QObject *parent) :
    QObject(parent)
{
	nm = new QNetworkAccessManager(this);
	connect(nm, SIGNAL(finished(QNetworkReply*)), this, SLOT(finished(QNetworkReply*)));
}

void ScriptureModel::setUrl(QString value)
{
	m_url = value;
	urlChanged(m_url);
	qDebug()<<m_url;

	QNetworkRequest request = QNetworkRequest(QUrl(m_url));
	//request.setRawHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.1.7) Gecko/20091221 Firefox/3.5.7 (.NET CLR 3.5.30729)" );
	nm->get(request);
}

void ScriptureModel::finished(QNetworkReply* reply)
{
	QVariant possibleRedirectUrl = reply->attribute(QNetworkRequest::RedirectionTargetAttribute);

	if(!possibleRedirectUrl.toUrl().isEmpty())
	{
		qDebug()<<"we got redirected to: "<<possibleRedirectUrl.toUrl().toString();
		nm->get(QNetworkRequest(possibleRedirectUrl.toUrl()));
		return;
	}

	qDebug()<<"apparently not a redirect...";

	qDebug()<<(int)reply->error()<<reply->errorString();

	QByteArray data = reply->readAll();
	//qDebug()<<"data: "<<data;
	QXmlQuery query;
	query.setFocus(QString(data));
	query.setQuery("//div[@class='verses']");
	query.evaluateTo(&m_verses);

	//find listen link if available:
	query.setQuery("//li[@id='listenLink']/a/@onclick/string()");
	query.evaluateTo(&m_listenUrl);

	m_listenUrl.remove(0,m_listenUrl.indexOf("http"));
	m_listenUrl.remove(m_listenUrl.indexOf("mp3") + 3,m_listenUrl.length() - m_listenUrl.indexOf("mp3"));

	listenUrlChanged(m_listenUrl);
	versesChanged(m_verses);

}
