racks = []
openers = []
static = []
eights = {}

puts "loading eight-work"
for line in open("eight-work") do
	tokens = line.strip.split(/ /)
	rack = tokens[0]
	work = tokens[1].to_i
	eights[rack] = work
end

puts "loading openers"
for line in open("openers") do
	tokens = line.strip.split(/ /)
	rack = tokens[0]
	racks << rack
	equity = tokens[1].to_f
	openers << equity
	puts rack + " " + equity.to_s
end

puts "loading static"
for line in open("static") do
	tokens = line.strip.split(/ /)
	rack = tokens[0]
	equity = tokens[1].to_f
	static << equity
end

def useWork(blank, work)
	if blank then
		case work
		when 0; return -1.08
		when 1..10; return 0.74
		when 11..15; return 3.16
		when 16..25; return 4.26
		when 26..35; return 5.68
		when 36..45; return 6.45
		when 46..93; return 7.40
		end
	else
		case work
		when 0; return -2.46
		when 1..5; return -1.79
		when 6..10; return 1.20
		when 11..15; return 4.51
		when 16..20; return 6.84
		when 21..25; return 8.84
		when 26..30; return 9.68
		when 31..35; return 11.29
		when 36..93; return 11.68
		end
	end
end

for i in 0..(racks.size) - 1 do	
  rack = racks[i]
	openEst = 0.806 * openers[i] - 26.04
	openEst = -36.5 if openEst < -36.5
			
	staticEst = static[i]
		
	bothEst = (openEst + staticEst) * 0.5
			
	estimate = staticEst - 3.497 if bothEst < -22
	estimate = bothEst - 1.156 if bothEst >= -22

	work = 0
	work = eights[rack] if eights[rack]
		
	estimate += useWork(rack.include?("?"), work)

	puts rack + " " + estimate.to_s
end
