#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QtGui/QMainWindow>
#include <QtNetwork>
#include <QAbstractSocket>

#include "imagegridwidget.h"
#include "host.h"

namespace Ui
{
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
    ~MainWindow();

private:
    void loadSettings();
    void saveSettings();
    void wakeUp(char address[], bool saveToList=false);
    void edit(Host& item);
    void hostFound(bool found);

#ifdef Q_WS_MAEMO_5
    void setLandscape(bool landscape=true, bool force=false);
    bool isLandscape();
#endif

private: // override
    void closeEvent(QCloseEvent *event);

private slots:
    void on_addBtt_clicked();

    void onImageGridClick(QMouseEvent& event, ImageGridWidget::Item* item);
    void onImageGridMenu(QContextMenuEvent& event, ImageGridWidget::Item* item);
    void onImageGridDblClick(QMouseEvent& event, ImageGridWidget::Item* item);

    // finding mac address
    void hostFound(QHostInfo host);
    void hostFound();
    void socketConnected();
    void socketError(QAbstractSocket::SocketError error);

private:
    Ui::MainWindow *ui;
    QUdpSocket  m_udpSocket;
    QSettings   m_settings;
    // QStringList m_recentList;

    // find mac
    QTcpSocket  m_tcpSocket;
    QHostAddress m_hostAddress;
};

#endif // MAINWINDOW_H
