#include "mainwindow.h"
#include "ui_mainwindow.h"

#include "newhostdlg.h"
#include "aboutdlg.h"
#include "testmousedlg.h"
#include "arp.h"

#include <QSettings>
#include <QInputDialog>
#include <QMessageBox>
#include <QMenu>
#include <QMouseEvent>
#include <QHostInfo>
#include <QNetworkInterface>
#include <QDesktopWidget>
#include <QDebug>

#ifdef Q_WS_MAEMO_5
    #include <QMaemo5InformationBox>
#endif

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent), ui(new Ui::MainWindow),
    // m_udpSocket(this),
    m_settings("crochik", "cuteWOL", this)
{
    ui->setupUi(this);

    ui->widget->setIsShowSelection(false);
    ui->widget->setBackgroundColor(QColor(0,0,0));
    ui->widget->setPenColor(QColor(255,128,0));

    connect(ui->widget, SIGNAL(onClick(QMouseEvent&, ImageGridWidget::Item*)),this, SLOT(onImageGridClick(QMouseEvent&, ImageGridWidget::Item*)));
    connect(ui->widget, SIGNAL(onDblClick(QMouseEvent&, ImageGridWidget::Item*)),this, SLOT(onImageGridDblClick(QMouseEvent&, ImageGridWidget::Item*)));
    connect(ui->widget, SIGNAL(onContextMenu(QContextMenuEvent&,ImageGridWidget::Item*)), this, SLOT(onImageGridMenu(QContextMenuEvent&,ImageGridWidget::Item*)));

    // tcp socket
    connect(&m_tcpSocket, SIGNAL(hostFound()), this, SLOT(hostFound()));
    connect(&m_tcpSocket, SIGNAL(error(QAbstractSocket::SocketError)), this, SLOT(socketError(QAbstractSocket::SocketError)));
    connect(&m_tcpSocket, SIGNAL(connected()), this, SLOT(socketConnected()));

#ifndef Q_WS_MAEMO_5
   statusBar()->show();
#else
   statusBar()->hide();
#endif

   loadSettings();
}

MainWindow::~MainWindow() {
    delete ui;
}

void MainWindow::closeEvent(QCloseEvent *event) {
    saveSettings();
}

void MainWindow::loadSettings() {
    Host::registerMeataType();

    QList<Host> hosts = m_settings.value("hosts").value< QList<Host> >();
    foreach ( Host host, hosts ) {
        Host *pHost = new Host(host);
        switch ( pHost->m_imageIndex ) {
            case 0: pHost->m_image = QImage(":/images/rc/1"); break;
            case 1: pHost->m_image = QImage(":/images/rc/2"); break;
            case 2: pHost->m_image = QImage(":/images/rc/3"); break;
            case 3: pHost->m_image = QImage(":/images/rc/4"); break;
            case 4: pHost->m_image = QImage(":/images/rc/5"); break;
            case 5: pHost->m_image = QImage(":/images/rc/6"); break;
            default: pHost->m_image= QImage(":/images/rc/7"); break;
        }

        ui->widget->add(pHost);
    }


#ifdef Q_WS_MAEMO_5
    QRect screenGeometry = QApplication::desktop()->screenGeometry();
    setLandscape( screenGeometry.width() > screenGeometry.height(), true );
#endif
}

#ifdef Q_WS_MAEMO_5
void MainWindow::setLandscape(bool landscape/*=true*/, bool force/*=false*/) {
    if ( !force && landscape==isLandscape() ) return;

    if ( landscape ) {
        setAttribute(Qt::WA_Maemo5PortraitOrientation, false);
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, true);

    } else {
        setAttribute(Qt::WA_Maemo5LandscapeOrientation, false);
        setAttribute(Qt::WA_Maemo5PortraitOrientation, true);

    }
}
bool MainWindow::isLandscape(){
    return testAttribute(Qt::WA_Maemo5LandscapeOrientation) || !testAttribute(Qt::WA_Maemo5PortraitOrientation);
}
#endif

void MainWindow::saveSettings() {
    QList<Host> hosts;
    for (int c=0; c<ui->widget->count(); c++) {
        hosts.append( *(Host*)ui->widget->itemAt(c) );
    }

    QVariant var;
    var.setValue(hosts);
    m_settings.setValue("hosts", var);
}

void MainWindow::onImageGridDblClick(QMouseEvent& event, ImageGridWidget::Item *pItem) {
    if ( !pItem ) return;

    // wake up!!!!
    Host* pHost = (Host*)pItem;
    char address[6];
    if ( pHost->getMacAddress(address) ) wakeUp(address, false);
}

void MainWindow::onImageGridClick(QMouseEvent& event, ImageGridWidget::Item* pItem) {
    if ( !pItem ) return;

    Host* pHost = (Host*)pItem;
    ui->lineEdit->setText(pHost->m_macAddress);
}

void MainWindow::onImageGridMenu(QContextMenuEvent& event, ImageGridWidget::Item* pItem) {
    if ( !pItem ) return;

    // right click: popup menu
    QMenu menu;
    QAction *pAction = menu.addAction("Broadcast");
    pAction->setData(QVariant(0));

    menu.addSeparator();

    pAction = menu.addAction("Edit");
    pAction->setData(QVariant(1));

    pAction = menu.addAction("Delete");
    pAction->setData(QVariant(2));

    pAction = menu.exec(event.globalPos());
    if ( !pAction ) return;

    Host* pHost = (Host*)pItem;
    switch ( pAction->data().toInt()) {
        case 0: {
                // broadcast
                char address[6];
                if ( !pHost->getMacAddress(address)) return;
                wakeUp(address, false);
            }
            break;

        case 1: // edit
            edit(*pHost);
            ui->widget->repaint();
            break;

        case 2: // delete
            if ( QMessageBox::question(this, "Remove Host?", "Are you sure?", QMessageBox::Yes, QMessageBox::No)!=QMessageBox::Yes ) return;
            ui->widget->del(pHost,true);
            break;
    }
}

void MainWindow::edit(Host& item) {
    NewHostDlg dlg;
    dlg.setWindowTitle("Edit Host");
    dlg.setSelectedName(item.m_name);
    dlg.imageGrid().setSelectedIndex(item.m_imageIndex);
    if ( dlg.exec() == QDialog::Rejected ) return;

    // update item
    item.m_imageIndex = dlg.imageGrid().getSelectedIndex();
    item.m_name = dlg.selectedName();
    item.m_image = dlg.imageGrid()[item.m_imageIndex].m_image;
}

void MainWindow::wakeUp(char address[], bool saveToList/*=false*/) {
    //set sending bites
    int counter = 0;

    //buffer to be send
    char bytes[102];

    //first 6 bytes should be 0xFF
    for (int y = 0; y < 6; y++) bytes[counter++] = 0xFF;

    //now repeate MAC 16 times
    for (int y = 0; y < 16; y++) {
        for (int z = 0; z < 6; z++) bytes[counter++] = address[z];
    }

    QString macAddress;
    for ( int c=0; c<6; c++ ) {
        if ( !c ) {
            macAddress = QString::number((unsigned char)address[c], 16).toUpper();
            continue;
        }
        macAddress += ":";
        macAddress += QString::number((unsigned char)address[c], 16).toUpper();
    }

    
#ifndef Q_WS_MAEMO_5
    ui->statusBar->showMessage(tr("Broadcasting: ") + macAddress);
#endif
    m_udpSocket.writeDatagram(bytes, 102, QHostAddress::Broadcast, 0); // , 45454
    m_udpSocket.writeDatagram(bytes, 102, QHostAddress::Broadcast, 7);
    m_udpSocket.writeDatagram(bytes, 102, QHostAddress::Broadcast, 9);

#ifdef Q_WS_MAEMO_5
    QMaemo5InformationBox::information(this,
        tr("Broadcasted to ") + macAddress,
        QMaemo5InformationBox::DefaultTimeout
    );
#else
    ui->statusBar->showMessage(tr("Broadcasted to ") + macAddress);
#endif

    if (!saveToList) return;

    // check if exists on the list
    for ( int c=0; c<ui->widget->count();  c++ ){
        Host& host( *(Host*)&(*ui->widget)[c] );
        if (host.m_macAddress.compare(macAddress)==0) {
            // exists
            return;
        }
    }

    NewHostDlg dlg;
    dlg.imageGrid().setSelectedIndex(0);
    if ( dlg.exec() == QDialog::Rejected ) return;
    QString text = dlg.selectedName();
    if (text.isEmpty()) return;

    int index = dlg.imageGrid().getSelectedIndex();
    QImage image = dlg.imageGrid()[index].m_image;

    Host* pHost = new Host(text, index, macAddress, image);
    ui->widget->add(pHost, true);
}

void MainWindow::on_addBtt_clicked()
{
    QRegExp decMac("^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)[\\.:](25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)[\\.:](25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)[\\.:](25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)[\\.:](25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)[\\.:](25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");
    QRegExp hexMac("^([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9])$");
    QRegExp ip("^(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.(25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)$");

    if (!hexMac.indexIn(ui->lineEdit->text())) {
        bool ok;
        char address[6];
        for ( int c=0; c<6; c++) {
            address[c] =  hexMac.cap(c+1).toInt(&ok, 16);
        }

        wakeUp(address, true);
        return;
    }

    if (!decMac.indexIn(ui->lineEdit->text())) {
        char address[6];
        for ( int c=0; c<6; c++) {
            address[c] =  decMac.cap(c+1).toInt();
        }
        wakeUp(address, true);
        return;
    }

    ui->lineEdit->setEnabled(false);
    ui->addBtt->setEnabled(false);

    if (!ip.indexIn(ui->lineEdit->text())) {
        // try to connect to ip
        m_hostAddress = QHostAddress(ui->lineEdit->text());
        m_tcpSocket.connectToHost(m_hostAddress, 80);
        return;
    }

    // look for host by name
    m_hostAddress = QHostAddress();
    QHostInfo::lookupHost(ui->lineEdit->text(), this, SLOT(hostFound(QHostInfo)));
}

void MainWindow::hostFound(QHostInfo host) {
    if ( host.error()!=QHostInfo::NoError ) {
        qDebug() << "Error: " << host.errorString();
        hostFound(false);
        return;
    }

    qDebug() << "Host " << host.hostName() << ": " << host.localDomainName() << ", " << host.localHostName();

    QList<QHostAddress> hosts = host.addresses();
    if ( hosts.count()!=1 ) {
        qDebug() << "Error getting address for host";
        hostFound(false);
        return;
    }

    m_hostAddress = hosts.at(0);
    qDebug() << ">> Address:" << m_hostAddress.toString();
    m_tcpSocket.connectToHost(m_hostAddress, 80);
}

void MainWindow::hostFound() {
    // wait for error or connection
}

void MainWindow::socketError(QAbstractSocket::SocketError error) {
    switch ( error ) {
        case QAbstractSocket::ConnectionRefusedError:
            qDebug() << "Connection refused (but host found!)";
            hostFound(true);
            break;

        case QAbstractSocket::HostNotFoundError:
        case QAbstractSocket::NetworkError:
        default:
            qDebug() << "Socket Error: " << error;
            hostFound(false);
            break;
    }

}

void MainWindow::socketConnected() {
    qDebug() << "Connceted";
    hostFound(true);
}

void MainWindow::hostFound(bool found) {
    m_tcpSocket.disconnectFromHost(); // ???

    ui->lineEdit->setEnabled(true);
    ui->addBtt->setEnabled(true);

    if ( m_hostAddress.isNull() ) { // !found
        QMessageBox::warning(this, ui->lineEdit->text(), "Host not found.");
        return;
    }

    Arp arp;
    if ( !arp.reload() ) {
        qDebug() << "Error running arp.";
        QMessageBox::warning(this, m_hostAddress.toString(), "Error starting arp (not linux?)");
        return;
    }

    QString hostAddress = m_hostAddress.toString();
    if ( !arp.m_hosts.contains(hostAddress) ) {
        QMessageBox::warning(this, hostAddress, "Couldn't find mac address for host.");
        return;
    }

    QRegExp hexMac("^([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9]):([a-fA-F0-9]?[a-fA-F0-9])$");
    if (!hexMac.indexIn(arp.m_hosts[hostAddress])) {
        bool ok;
        char address[6];
        bool invalid = true;
        for ( int c=0; c<6; c++) {
            address[c] =  hexMac.cap(c+1).toInt(&ok, 16);
            if (address[c]!=0) invalid = false;
        }

        if ( invalid ) {
            QMessageBox::warning(this, hostAddress, "Couldn't find mac address for host.");
            return;
        }

        wakeUp(address, true);
        return;
    }
}
