#ifndef IMAGEGRIDWIDGET_H
#define IMAGEGRIDWIDGET_H

#include <QWidget>
#include <QImage>
#include <QList>

class /*QDESIGNER_WIDGET_EXPORT */ ImageGridWidget : public QWidget
{
    Q_OBJECT
    Q_PROPERTY(QColor penColor READ penColor WRITE setPenColor)
    Q_PROPERTY(QColor backgroundColor READ backgroundColor WRITE setBackgroundColor)
    Q_PROPERTY(QColor selectedColor READ selectedColor WRITE setSelectedColor)
    Q_PROPERTY(QFont font READ font WRITE setFont)

public:
    class Item {
    public:
        Item() { } // empty?
        Item(const Item& other) {
            m_image = other.m_image;
            m_name = other.m_name;
        }

        Item(QImage image, QString name) {
            m_image=image;
            m_name=name;
        }

        bool operator==(const Item& other) {
            return m_name==other.m_name;
        }

    public:
        QImage  m_image;
        QString m_name;
    };

public:
    ImageGridWidget(QWidget* parent=NULL);
    ~ImageGridWidget();

    void clear();


public: // properties
    void setPenColor(const QColor &newColor);
    QColor penColor() const;
    void setBackgroundColor(const QColor &newColor);
    QColor backgroundColor() const;
    void setSelectedColor(const QColor &newColor);
    QColor selectedColor() const;
    void setFont(const QFont &newFont);
    QFont font() const;
    int getSelectedIndex() const;
    void setSelectedIndex(int index);
    bool isShowSelection() const;
    void setIsShowSelection(bool show);

public:
    void add(Item* pItem, bool repaint=true);
    void del(Item* pItem, bool repaint=true);
    void setAspectRatio(int x, int y);

    int count() const;
    Item& operator[](int index);
    Item* itemAt(int index);

signals:
    void onClick(QMouseEvent& event, ImageGridWidget::Item* pItem);
    void onContextMenu(QContextMenuEvent& event, ImageGridWidget::Item* pItem);
    void onDblClick(QMouseEvent& event, ImageGridWidget::Item* pItem);

protected:
    int getIndex(int x, int y);
    QRect getRect(int index);
    void calculate();

protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseDoubleClickEvent(QMouseEvent *event);
    void contextMenuEvent(QContextMenuEvent *pEvent);

    void leaveEvent(QEvent *event);
    void resizeEvent ( QResizeEvent * event );
    void paintEvent(QPaintEvent *event);

private:
    double m_aspectRatio;
    int m_x;
    int m_y;
    int m_width;
    int m_height;
    int m_offX;
    int m_offY;

    QList<Item*> m_list;

    int m_selIndex;
    int m_mouseOverIndex;
    QFont m_font;
    QColor m_penColor;
    QColor m_backgroundColor;

    QColor m_clickColor;         // mouse click color
    QColor m_selColor;          // selected cell background color
    QColor m_selBorderColor;     // selected cell border color

    bool m_showSelection;
    int m_padding;              // padding
};

#endif // IMAGEGRIDWIDGET_H
