#include "arp.h"

#include <QProcess>

Arp::Arp(){
}

bool Arp::reload() {
    m_hosts.clear();

#ifndef Q_OS_LINUX
    return false;

#else
    QProcess process;
    process.start("cat /proc/net/arp");
    if (!process.waitForStarted() || !process.waitForFinished()) {
        return false;
    }

    QRegExp regExp("\\s+");
    while ( !process.atEnd()) {
        QByteArray array = process.readLine();
        QString line(array);
        QStringList list = line.split(regExp);
        if ( list.count()!=7 ) continue;

        m_hosts[list.at(0)] = list.at(3);
    }

    return true;
#endif
}
