#include "hexspinbox.h"

HexSpinBox::HexSpinBox(QWidget *parent /*= 0*/)
        : QSpinBox(parent),
        m_validator(QRegExp("[0-9A-Fa-f]{1,8}"), this)
{
    setRange(0,255);
    m_isDecimal = false;
}

QValidator::State HexSpinBox::validate(QString &text, int &pos) const {
    if (m_isDecimal) return QSpinBox::validate(text,pos);
    return m_validator.validate(text, pos);
}

QString HexSpinBox::textFromValue(int value) const {
    if (m_isDecimal) return QSpinBox::textFromValue(value);
    return QString::number(value, 16).toUpper();
}

int HexSpinBox::valueFromText(const QString &text) const {
    if (m_isDecimal) return QSpinBox::valueFromText(text);

    bool ok;
    return text.toInt(&ok, 16);
}

bool HexSpinBox::isDecimal() {
    return m_isDecimal;
}

void HexSpinBox::setIsDecimal(bool isDecimal){
    m_isDecimal = isDecimal;

    setValue(value()); //???
}
