#include "graphframe.h"
#include <QApplication>

GraphFrame::GraphFrame(QString& title, QPixmap& graphPix){
	layout = new QVBoxLayout();

	this->graph = new QLabel();
	graph->setPixmap(graphPix);
	graph->setScaledContents(true);
	graph->setSizePolicy(QSizePolicy::Fixed, QSizePolicy::MinimumExpanding);
	graph->setMinimumWidth(1600);
	graph->setMinimumHeight(220);


	this->title = new QLabel(title);
	this->title->setAutoFillBackground(true);
	colorize(this->title);

	this->scrollArea = new QScrollArea();
	scrollArea->setSizePolicy(QSizePolicy::MinimumExpanding, QSizePolicy::Fixed);
	scrollArea->setMinimumHeight(240);
	scrollArea->setWidget(graph);


	layout->addWidget(this->title);
	layout->addWidget(scrollArea);

}


GraphFrame::~GraphFrame(){
	delete layout;
	delete title;
	delete graph;
	delete scrollArea;
}

QVBoxLayout* GraphFrame::getLayout(){
	return layout;
}

void GraphFrame::colorize(QLabel *label){
	label->setPalette(QApplication::palette().highlight().color());
	QPalette pal = label->palette();

	QLinearGradient linearGrad(QPointF(0, 0), QPointF(0, 35));
	linearGrad.setColorAt(0, pal.color(QPalette::Highlight));
	linearGrad.setColorAt(1, Qt::black);
	QBrush brush(linearGrad);

	pal.setBrush(QPalette::Window, brush);;
	label->setPalette(pal);
}
