#include "stackedwindow.h"
#include <QPropertyAnimation>
#include "ui_stackedwindow.h"
#include "mainwindow.h"


StackedWindow::StackedWindow(QDomDocument *doc, QPixmap &dayIcon, int dayVar, QPixmap &nightIcon, int nightVar, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::StackedWindow)
{
    ui->setupUi(this);
	this->doc = doc;
	QDomElement docEle = doc->documentElement();
	QDomNodeList days = docEle.elementsByTagName("day");

	QString tempTitle("<b>Temperature and Wind Chill: </b>"), precipTitle("<b>Precipitation and Humidity: </b> ");
	QString rainTitle("<b>Rain Accumulation: </b>"), snowTitle("<b>Snow Accumulation: </b> ");
	QPixmap tempPix(1600, 220);


	/*init block*/
	bool needDay = false;
	bool needNight = false;
	manager = new QNetworkAccessManager(this);
	mapper = new QSignalMapper(this);
	tempFrame = new GraphFrame(tempTitle, tempPix);
	precipFrame = new GraphFrame(precipTitle, tempPix);
	rainFrame = 0;
	snowFrame = 0;
	QString dayURL(QUrl::fromPercentEncoding(days.at(dayVar).namedItem("icon").toElement().text().toStdString().c_str()));
	QString nightURL(QUrl::fromPercentEncoding(days.at(nightVar).namedItem("icon").toElement().text().toStdString().c_str()));
	QString tempSearch = QUrl::fromPercentEncoding(days.at(dayVar).namedItem("tempGraph").toElement().text().toStdString().c_str());
	QString precipSearch = QUrl::fromPercentEncoding(days.at(dayVar).namedItem("precipGraph").toElement().text().toStdString().c_str());
	QString* searchParams[4] = {&tempSearch, &precipSearch, &dayURL, &nightURL};

	ui->day->setText(days.at(dayVar).namedItem("name").toElement().text());
	ui->hi->setText(days.at(dayVar).namedItem("temp").toElement().text());
	ui->lo->setText(days.at(nightVar).namedItem("temp").toElement().text());
	ui->precip->setText("Precipitation: " + days.at(dayVar).namedItem("precipitation").toElement().text());
	ui->dayForecast->setText(days.at(dayVar).namedItem("wordedForecast").toElement().text());
	ui->nightForecast->setText(days.at(nightVar).namedItem("wordedForecast").toElement().text());
	MainWindow::colorize(ui->label_3);

	/*add the layouts to the ui*/
	QVBoxLayout* layout = qobject_cast<QVBoxLayout*>(ui->frame->layout());
	layout->addLayout(tempFrame->getLayout());
	layout->addLayout(precipFrame->getLayout());
    connect(mapper, SIGNAL(mapped(int)), this, SLOT(setIcons(int)));



	if(!dayIcon.isNull()){
		ui->dayIcon->setPixmap(dayIcon);
	}else{
		needDay = true;
		ui->dayIcon->setPixmap(QPixmap(":/loading.png"));
	}

	if(!nightIcon.isNull()){
		ui->nightIcon->setPixmap(nightIcon);
    }else{
        needNight = true;
        ui->nightIcon->setPixmap(QPixmap(":/loading.png"));
    }

    //send the icon requests and map them so they end up
    //in the right place
    for(int i = 0; i < 4; i++){
        if(i < 2 || needDay & i==2 || needNight & i==3){
            QNetworkReply* reply = manager->get(QNetworkRequest(QUrl(*searchParams[i])));
            connect(reply, SIGNAL(finished()), mapper, SLOT(map()));
            mapper->setMapping(reply, i);
        }

    }




	if(ui->dayForecast->text().contains("ain") || ui->nightForecast->text().contains("ain")){
		rainFrame = new GraphFrame(rainTitle, tempPix);
		layout->addLayout(rainFrame->getLayout());
		QNetworkReply* reply = manager->get(QNetworkRequest(QUrl(QUrl::fromPercentEncoding(days.at(dayVar).namedItem("rainGraph").toElement().text().toStdString().c_str()))));
		connect(reply, SIGNAL(finished()), this, SLOT(addRainGraph()));
	}

	if(ui->dayForecast->text().contains("now") || ui->nightForecast->text().contains("now")){
		snowFrame = new GraphFrame(snowTitle, tempPix);
		layout->addLayout(snowFrame->getLayout());
		QNetworkReply* reply = manager->get(QNetworkRequest(QUrl(QUrl::fromPercentEncoding(days.at(dayVar).namedItem("snowGraph").toElement().text().toStdString().c_str()))));
		connect(reply, SIGNAL(finished()), this, SLOT(addSnowGraph()));
	}


}

StackedWindow::~StackedWindow()
{
    delete ui;
	delete manager;
	delete mapper;
	delete rainFrame;
	delete snowFrame;
	delete tempFrame;
	delete precipFrame;
}


void StackedWindow::setIcons(int mapping){
    QSignalMapper* sm = qobject_cast<QSignalMapper*>(sender());
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(sm->mapping(mapping));
	reply->deleteLater();
    QPixmap pix;
    pix.loadFromData(reply->readAll());

    switch(mapping){
	case 0: tempFrame->setPix(pix);break;
	case 1: precipFrame->setPix(pix);break;
	case 2: ui->dayIcon->setPixmap(pix);break;
	case 3: ui->nightIcon->setPixmap(pix);break;
    }
}


/**
  Slot to add the snow graph to this window.
  Called only if the forecast includes snow
  */
void StackedWindow::addSnowGraph(){
	QNetworkReply* reply = qobject_cast<QNetworkReply*>(sender());
	reply->deleteLater();
	QPixmap pix; pix.loadFromData(reply->readAll());
	snowFrame->setPix(pix);
}

/**
  Slot to add the rain graph to this window.
  Called only if the forecast includes rain
  */
void StackedWindow::addRainGraph(){
	QNetworkReply* reply = qobject_cast<QNetworkReply*>(sender());
	reply->deleteLater();
	QPixmap pix; pix.loadFromData(reply->readAll());
	rainFrame->setPix(pix);
}



void StackedWindow::resizeEvent(QResizeEvent *event){
    if(event->oldSize().width() > event->size().width()){
		ui->frame->setMinimumWidth(100);
    }else{
		ui->frame->setMinimumWidth(720);
    }

}

