#include "stackedwindow.h"
#include "ui_stackedwindow.h"
#include <iostream>
using namespace std;


using namespace std;

StackedWindow::StackedWindow(QString* latlong, QString* wfo, QString* zcode,
                             QString* offset, QPixmap *dayIcon, QString* dayURL,
                             QPixmap *nightIcon, QString* nightURL, QWidget *parent) :
    QMainWindow(parent),
    ui(new Ui::StackedWindow)
{
    ui->setupUi(this);
    QString zc("MEZ015");
    zcode = &zc;//QString("MEZ015"); // delete this line once we find a way to get the zcode

    QString* tempSearch = new QString("http://forecast.weather.gov/wtf/meteograms/Plotter.php?" + *latlong + "&wfo=" + *wfo + "&zcode=" + *zcode + "&gset=20&gdiff=10&unit=0&tinfo=EY5&ahour=" + *offset +"&pcmd=100100000000000000000000000000000000000000000000&lg=en&indu=1!1!1&dd=0&bw=0&hrspan=48&pqpfhr=6");
    QString* precipSearch = new QString("http://forecast.weather.gov/wtf/meteograms/Plotter.php?" + *latlong + "&wfo=" + *wfo + "&zcode=" + *zcode + "&gset=20&gdiff=10&unit=0&tinfo=EY5&ahour=" + *offset +"&pcmd=000000110000000000000000000000000000000000000000&lg=en&indu=1!1!1&dd=0&bw=0&hrspan=48&pqpfhr=6");
    QString* searchParams[4] = {tempSearch, precipSearch, dayURL, nightURL};



    mapper = new QSignalMapper(this);
    connect(mapper, SIGNAL(mapped(int)), this, SLOT(setIcons(int)));
    manager = new QNetworkAccessManager(this);


    bool needDay = false;
    bool needNight = false;




    if(!dayIcon->isNull()){
        ui->dayIcon->setPixmap(*dayIcon);
    }else{
        needDay = true;
        ui->dayIcon->setPixmap(QPixmap(":/loading.png"));
    }

    if(!nightIcon->isNull()){
        ui->nightIcon->setPixmap(*nightIcon);
    }else{
        needNight = true;
        ui->nightIcon->setPixmap(QPixmap(":/loading.png"));
    }

    //send the icon requests and map them so they end up
    //in the right place
    for(int i = 0; i < 4; i++){
        if(i < 2 || needDay & i==2 || needNight & i==3){
            QNetworkReply* reply = manager->get(QNetworkRequest(QUrl(*searchParams[i])));
            connect(reply, SIGNAL(finished()), mapper, SLOT(map()));
            mapper->setMapping(reply, i);
        }

    }


}

StackedWindow::~StackedWindow()
{
    delete ui;
    delete manager;
    delete mapper;
}


void StackedWindow::setIcons(int mapping){
    QSignalMapper* sm = qobject_cast<QSignalMapper*>(sender());
    QNetworkReply* reply = qobject_cast<QNetworkReply*>(sm->mapping(mapping));
    QPixmap pix;
    pix.loadFromData(reply->readAll());

    switch(mapping){

    case 0:
        ui->tempGraph->setPixmap(pix);
        ui->tempGraph->setScaledContents(true);
        break;
    case 1:
        ui->precipGraph->setPixmap(pix);
        ui->precipGraph->setScaledContents(true);
        break;
    case 2:
        ui->dayIcon->setPixmap(pix);
        break;
    case 3:
        ui->nightIcon->setPixmap(pix);
        break;
    }
}


void StackedWindow::setInfo(QString &day, QString &hi, QString &lo,
                            QString &precip, QString &dayFor, QString &nightFor){


    ui->tempGraph->setScaledContents(false);
    ui->tempGraph->setAlignment(Qt::AlignHCenter);
    ui->tempGraph->setPixmap(QPixmap(":/loading.png"));
    ui->precipGraph->setScaledContents(false);
    ui->precipGraph->setAlignment(Qt::AlignHCenter);
    ui->precipGraph->setPixmap(QPixmap(":/loading.png"));

    ui->day->setText(day);
    ui->hi->setText(hi);
    ui->lo->setText(lo);
    ui->precip->setText(precip);
    ui->dayForecast->setText(dayFor);
    ui->nightForecast->setText(nightFor);

    ui->label->setPalette(QApplication::palette().highlight().color());
    ui->label_2->setPalette(QApplication::palette().highlight().color());
    ui->label_3->setPalette(QApplication::palette().highlight().color());
}



void StackedWindow::resizeEvent(QResizeEvent *event){
    if(event->oldSize().width() > event->size().width()){
        ui->frame->setMinimumWidth(100);
    }else{
        ui->frame->setMinimumWidth(720);
    }

}
