#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QDomDocument>
#include "commonIncludes.h"
#include "progressdialog.h"
#include "dayperiod.h"

namespace Ui {
    class MainWindow;
}

class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    explicit MainWindow(QWidget *parent = 0);
    ~MainWindow();

protected:
    virtual void resizeEvent(QResizeEvent * event);

private slots:
    void replyFinished(QNetworkReply *reply);
    void setFIcon(QNetworkReply *reply);
    void dayClick(QModelIndex index);
    void changeZip();
    void visitNAOO();
    void zipEvent(){
        changeZip();
    }

signals:
    void uiReady();



private:
    Ui::MainWindow *ui;
    QDomDocument *doc;
    QNetworkAccessManager *manager;
    QString zipCode;
    QString zipCache;
    QString *latlon;
    QString *wfo;
    QString *zcode;
    QList<QString*> *iconURLs;
    QList<DayPeriod*> *dayPeriods;
    QIcon *icon;
    int iconCount;
    bool needCoords;
    bool needShowList;
    ProgressDialog *pg;

    void detailWindow(int day);
    void setDomDocument(QString* reply);


};

#endif // MAINWINDOW_H
